/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.base.messages.InternalPlcRequest;
import org.apache.plc4x.java.base.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.base.messages.PlcSubscriber;
import org.apache.plc4x.java.base.model.InternalPlcSubscriptionHandle;

public class DefaultPlcUnsubscriptionRequest
implements InternalPlcUnsubscriptionRequest,
InternalPlcRequest {
    private final PlcSubscriber subscriber;
    private final Collection<? extends InternalPlcSubscriptionHandle> internalPlcSubscriptionHandles;

    public DefaultPlcUnsubscriptionRequest(PlcSubscriber subscriber, Collection<? extends InternalPlcSubscriptionHandle> internalPlcSubscriptionHandles) {
        this.subscriber = subscriber;
        this.internalPlcSubscriptionHandles = internalPlcSubscriptionHandles;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
        return this.subscriber.unsubscribe(this);
    }

    @Override
    public Collection<? extends InternalPlcSubscriptionHandle> getInternalPlcSubscriptionHandles() {
        return this.internalPlcSubscriptionHandles;
    }

    public static class Builder
    implements PlcUnsubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private List<InternalPlcSubscriptionHandle> plcSubscriptionHandles;

        public Builder(PlcSubscriber subscriber) {
            this.subscriber = subscriber;
            this.plcSubscriptionHandles = new ArrayList<InternalPlcSubscriptionHandle>();
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
            this.plcSubscriptionHandles.add((InternalPlcSubscriptionHandle)plcSubscriptionHandle);
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
            this.plcSubscriptionHandles.add((InternalPlcSubscriptionHandle)plcSubscriptionHandle1);
            this.plcSubscriptionHandles.addAll(Arrays.stream(plcSubscriptionHandles).map(InternalPlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandles) {
            this.plcSubscriptionHandles.addAll(plcSubscriptionHandles.stream().map(InternalPlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest build() {
            return new DefaultPlcUnsubscriptionRequest(this.subscriber, this.plcSubscriptionHandles);
        }
    }
}

