/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.base.connection.PlcFieldHandler;
import org.apache.plc4x.java.base.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.PlcSubscriber;
import org.apache.plc4x.java.base.model.SubscriptionPlcField;

public class DefaultPlcSubscriptionRequest
implements InternalPlcSubscriptionRequest,
InternalPlcFieldRequest {
    private final PlcSubscriber subscriber;
    private LinkedHashMap<String, SubscriptionPlcField> fields;

    public DefaultPlcSubscriptionRequest(PlcSubscriber subscriber, LinkedHashMap<String, SubscriptionPlcField> fields) {
        this.subscriber = subscriber;
        this.fields = fields;
    }

    public CompletableFuture<PlcSubscriptionResponse> execute() {
        return this.subscriber.subscribe(this);
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    public PlcField getField(String name) {
        SubscriptionPlcField subscriptionPlcField = this.fields.get(name);
        if (subscriptionPlcField == null) {
            return null;
        }
        return subscriptionPlcField.getPlcField();
    }

    public List<PlcField> getFields() {
        return this.fields.values().stream().map(SubscriptionPlcField::getPlcField).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public List<SubscriptionPlcField> getSubscriptionFields() {
        return new LinkedList<SubscriptionPlcField>(this.fields.values());
    }

    @Override
    public LinkedHashMap<String, SubscriptionPlcField> getSubscriptionPlcFieldMap() {
        return this.fields;
    }

    @Override
    public List<Pair<String, PlcField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPlcFieldEntry -> Pair.of(stringPlcFieldEntry.getKey(), (Object)((SubscriptionPlcField)stringPlcFieldEntry.getValue()).getPlcField())).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public List<Pair<String, SubscriptionPlcField>> getNamedSubscriptionFields() {
        return this.fields.entrySet().stream().map(stringPlcFieldEntry -> Pair.of(stringPlcFieldEntry.getKey(), stringPlcFieldEntry.getValue())).collect(Collectors.toCollection(LinkedList::new));
    }

    protected PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    public static class Builder
    implements PlcSubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final PlcFieldHandler fieldHandler;
        private final Map<String, BuilderItem> fields;

        public Builder(PlcSubscriber subscriber, PlcFieldHandler fieldHandler) {
            this.subscriber = subscriber;
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, BuilderItem>();
        }

        public PlcSubscriptionRequest.Builder addCyclicField(String name, String fieldQuery, Duration pollingInterval) {
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.CYCLIC, pollingInterval));
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateField(String name, String fieldQuery) {
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.CHANGE_OF_STATE));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventField(String name, String fieldQuery) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.EVENT));
            return this;
        }

        public PlcSubscriptionRequest build() {
            LinkedHashMap<String, SubscriptionPlcField> parsedFields = new LinkedHashMap<String, SubscriptionPlcField>();
            this.fields.forEach((name, builderItem) -> {
                PlcField parsedField = this.fieldHandler.createField(((BuilderItem)builderItem).fieldQuery);
                parsedFields.put((String)name, new SubscriptionPlcField(((BuilderItem)builderItem).plcSubscriptionType, parsedField, ((BuilderItem)builderItem).duration));
            });
            return new DefaultPlcSubscriptionRequest(this.subscriber, parsedFields);
        }

        private static class BuilderItem {
            private final String fieldQuery;
            private final PlcSubscriptionType plcSubscriptionType;
            private final Duration duration;

            private BuilderItem(String fieldQuery, PlcSubscriptionType plcSubscriptionType) {
                this(fieldQuery, plcSubscriptionType, (Duration)null);
            }

            private BuilderItem(String fieldQuery, PlcSubscriptionType plcSubscriptionType, Duration duration) {
                this.fieldQuery = fieldQuery;
                this.plcSubscriptionType = plcSubscriptionType;
                this.duration = duration;
            }
        }
    }
}

