/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.PlcFieldHandler;
import org.apache.plc4x.java.base.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.PlcReader;

public class DefaultPlcReadRequest
implements InternalPlcReadRequest,
InternalPlcFieldRequest {
    private final PlcReader reader;
    private LinkedHashMap<String, PlcField> fields;

    protected DefaultPlcReadRequest(PlcReader reader, LinkedHashMap<String, PlcField> fields) {
        this.reader = reader;
        this.fields = fields;
    }

    public CompletableFuture<PlcReadResponse> execute() {
        return this.reader.read(this);
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    public PlcField getField(String name) {
        return this.fields.get(name);
    }

    public List<PlcField> getFields() {
        return new LinkedList<PlcField>(this.fields.values());
    }

    @Override
    public List<Pair<String, PlcField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPlcFieldEntry -> Pair.of(stringPlcFieldEntry.getKey(), stringPlcFieldEntry.getValue())).collect(Collectors.toCollection(LinkedList::new));
    }

    protected PlcReader getReader() {
        return this.reader;
    }

    public static class Builder
    implements PlcReadRequest.Builder {
        private final PlcReader reader;
        private final PlcFieldHandler fieldHandler;
        private final Map<String, String> fields;

        public Builder(PlcReader reader, PlcFieldHandler fieldHandler) {
            this.reader = reader;
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, String>();
        }

        public PlcReadRequest.Builder addItem(String name, String fieldQuery) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, fieldQuery);
            return this;
        }

        public PlcReadRequest build() {
            LinkedHashMap<String, PlcField> parsedFields = new LinkedHashMap<String, PlcField>();
            this.fields.forEach((name, fieldQuery) -> {
                PlcField parsedField = this.fieldHandler.createField((String)fieldQuery);
                parsedFields.put((String)name, parsedField);
            });
            return new DefaultPlcReadRequest(this.reader, parsedFields);
        }
    }
}

