/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcIoException;
import org.apache.plc4x.java.base.connection.AbstractPlcConnection;
import org.apache.plc4x.java.base.connection.ChannelFactory;

public abstract class NettyPlcConnection
extends AbstractPlcConnection {
    protected static final Timer timer = new HashedWheelTimer();
    protected final ChannelFactory channelFactory;
    protected final boolean awaitSessionSetupComplete;
    protected Channel channel;
    protected boolean connected;

    protected NettyPlcConnection(ChannelFactory channelFactory) {
        this(channelFactory, false);
    }

    protected NettyPlcConnection(ChannelFactory channelFactory, boolean awaitSessionSetupComplete) {
        this.channelFactory = channelFactory;
        this.awaitSessionSetupComplete = awaitSessionSetupComplete;
        this.connected = false;
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture<Void> sessionSetupCompleteFuture = new CompletableFuture<Void>();
            this.channel = this.channelFactory.createChannel(this.getChannelHandler(sessionSetupCompleteFuture));
            this.channel.closeFuture().addListener(future -> {
                if (!sessionSetupCompleteFuture.isDone()) {
                    sessionSetupCompleteFuture.completeExceptionally((Throwable)new PlcIoException("Connection terminated by remote"));
                }
            });
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> ping() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.channelFactory.ping();
            future.complete(null);
        }
        catch (PlcException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void close() throws PlcConnectionException {
        this.channel = null;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected && this.channel.isActive();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected abstract ChannelHandler getChannelHandler(CompletableFuture<Void> var1);

    protected void sendChannelCreatedEvent() {
    }
}

