/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.connection;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedOperationException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.base.messages.InternalPlcMessage;

public abstract class AbstractPlcConnection
implements PlcConnection,
PlcConnectionMetadata {
    public PlcConnectionMetadata getMetadata() {
        return this;
    }

    public CompletableFuture<Void> ping() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally((Throwable)new PlcUnsupportedOperationException("The connection does not support pinging"));
        return future;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean canSubscribe() {
        return false;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        throw new PlcUnsupportedOperationException("The connection does not support reading");
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        throw new PlcUnsupportedOperationException("The connection does not support writing");
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        throw new PlcUnsupportedOperationException("The connection does not support subscription");
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        throw new PlcUnsupportedOperationException("The connection does not support subscription");
    }

    protected <T extends InternalPlcMessage> T checkInternal(Object o, Class<T> clazz) {
        Objects.requireNonNull(o);
        Objects.requireNonNull(clazz);
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException("illegal type " + o.getClass() + ". Expected " + clazz);
        }
        return (T)((InternalPlcMessage)clazz.cast(o));
    }
}

