/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.connection;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.ChannelFactory;
import org.apache.plc4x.java.base.connection.NettyPlcConnection;
import org.apache.plc4x.java.base.connection.PlcFieldHandler;
import org.apache.plc4x.java.base.connection.TcpSocketChannelFactory;
import org.apache.plc4x.java.base.events.ConnectEvent;
import org.apache.plc4x.java.base.events.ConnectedEvent;
import org.apache.plc4x.java.base.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcRequest;
import org.apache.plc4x.java.base.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.base.messages.PlcReader;
import org.apache.plc4x.java.base.messages.PlcRequestContainer;
import org.apache.plc4x.java.base.messages.PlcWriter;
import org.apache.plc4x.java.isoontcp.protocol.IsoOnTcpProtocol;
import org.apache.plc4x.java.isotp.protocol.IsoTPProtocol;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DisconnectRequestTpdu;
import org.apache.plc4x.java.isotp.protocol.model.types.DeviceGroup;
import org.apache.plc4x.java.isotp.protocol.model.types.DisconnectReason;
import org.apache.plc4x.java.isotp.protocol.model.types.TpduSize;
import org.apache.plc4x.java.s7.model.S7Field;
import org.apache.plc4x.java.s7.netty.Plc4XS7Protocol;
import org.apache.plc4x.java.s7.netty.S7Protocol;
import org.apache.plc4x.java.s7.netty.strategies.DefaultS7MessageProcessor;
import org.apache.plc4x.java.s7.netty.strategies.S7MessageProcessor;
import org.apache.plc4x.java.s7.netty.util.S7PlcFieldHandler;
import org.apache.plc4x.java.s7.types.S7ControllerType;
import org.apache.plc4x.java.s7.utils.S7TsapIdEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7PlcConnection
extends NettyPlcConnection
implements PlcReader,
PlcWriter {
    private static final int ISO_ON_TCP_PORT = 102;
    private static final Configuration CONF = new SystemConfiguration();
    private static final long CLOSE_DEVICE_TIMEOUT_MS = CONF.getLong("plc4x.s7connection.close.device,timeout", 1000L);
    private static final Logger logger = LoggerFactory.getLogger(S7PlcConnection.class);
    private final int rack;
    private final int slot;
    private final short paramPduSize;
    private final short paramMaxAmqCaller;
    private final short paramMaxAmqCallee;
    private final S7ControllerType paramControllerType;

    public S7PlcConnection(InetAddress address, int rack, int slot, String params) {
        this((ChannelFactory)new TcpSocketChannelFactory(address, 102), rack, slot, params);
        logger.info("Setting up S7 Connection with: host-name {}, rack {}, slot {}, pdu-size {}, max-amq-caller {}, max-amq-callee {}", new Object[]{address.getHostAddress(), rack, slot, this.paramPduSize, this.paramMaxAmqCaller, this.paramMaxAmqCallee});
    }

    public S7PlcConnection(ChannelFactory channelFactory, int rack, int slot, String params) {
        super(channelFactory, true);
        this.rack = rack;
        this.slot = slot;
        int curParamPduSize = 1024;
        int curParamMaxAmqCaller = 8;
        int curParamMaxAmqCallee = 8;
        S7ControllerType curParamControllerType = S7ControllerType.ANY;
        if (!StringUtils.isEmpty((CharSequence)params)) {
            for (String param : params.split("&")) {
                String[] paramElements = param.split("=");
                String paramName = paramElements[0];
                if (paramElements.length == 2) {
                    String paramValue = paramElements[1];
                    switch (paramName) {
                        case "pdu-size": {
                            curParamPduSize = Short.parseShort(paramValue);
                            break;
                        }
                        case "max-amq-caller": {
                            curParamMaxAmqCaller = Short.parseShort(paramValue);
                            break;
                        }
                        case "max-amq-callee": {
                            curParamMaxAmqCallee = Short.parseShort(paramValue);
                            break;
                        }
                        case "controller-type": {
                            curParamControllerType = S7ControllerType.valueOf((String)paramValue);
                            break;
                        }
                        default: {
                            logger.debug("Unknown parameter {} with value {}", (Object)paramName, (Object)paramValue);
                            break;
                        }
                    }
                    continue;
                }
                logger.debug("Unknown no-value parameter {}", (Object)paramName);
            }
        }
        if (curParamControllerType == S7ControllerType.LOGO && curParamPduSize == 1024) {
            curParamPduSize = 480;
        }
        this.paramPduSize = (short)curParamPduSize;
        this.paramMaxAmqCaller = (short)curParamMaxAmqCaller;
        this.paramMaxAmqCallee = (short)curParamMaxAmqCallee;
        this.paramControllerType = curParamControllerType;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    protected ChannelHandler getChannelHandler(final CompletableFuture<Void> sessionSetupCompleteFuture) {
        final short calledTsapId = S7TsapIdEncoder.encodeS7TsapId((DeviceGroup)DeviceGroup.OS, (int)0, (int)0);
        final short callingTsapId = S7TsapIdEncoder.encodeS7TsapId((DeviceGroup)DeviceGroup.PG_OR_PC, (int)this.rack, (int)this.slot);
        return new ChannelInitializer(){

            protected void initChannel(Channel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof ConnectedEvent) {
                            sessionSetupCompleteFuture.complete(null);
                        } else {
                            super.userEventTriggered(ctx, evt);
                        }
                    }
                }});
                pipeline.addLast(new ChannelHandler[]{new IsoOnTcpProtocol()});
                pipeline.addLast(new ChannelHandler[]{new IsoTPProtocol(callingTsapId, calledTsapId, TpduSize.valueForGivenSize((int)S7PlcConnection.this.paramPduSize))});
                pipeline.addLast(new ChannelHandler[]{new S7Protocol(S7PlcConnection.this.paramMaxAmqCaller, S7PlcConnection.this.paramMaxAmqCallee, S7PlcConnection.this.paramPduSize, S7PlcConnection.this.paramControllerType, (S7MessageProcessor)new DefaultS7MessageProcessor())});
                pipeline.addLast(new ChannelHandler[]{new Plc4XS7Protocol()});
            }
        };
    }

    protected void sendChannelCreatedEvent() {
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
    }

    public PlcField prepareField(String fieldQuery) throws PlcInvalidFieldException {
        return S7Field.of((String)fieldQuery);
    }

    public int getRack() {
        return this.rack;
    }

    public int getSlot() {
        return this.slot;
    }

    public short getParamPduSize() {
        return this.paramPduSize;
    }

    public int getParamMaxAmqCaller() {
        return this.paramMaxAmqCaller;
    }

    public int getParamMaxAmqCallee() {
        return this.paramMaxAmqCallee;
    }

    public S7ControllerType getParamControllerType() {
        return this.paramControllerType;
    }

    public void close() throws PlcConnectionException {
        if (this.channel != null && this.channel.isOpen()) {
            DisconnectRequestTpdu disconnectRequest = new DisconnectRequestTpdu(0, 15, DisconnectReason.NORMAL, Collections.emptyList(), Unpooled.EMPTY_BUFFER);
            CompletableFuture disconnectFuture = new CompletableFuture();
            this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> disconnectFuture.complete(null)));
            this.channel.writeAndFlush((Object)disconnectRequest);
            try {
                disconnectFuture.get(CLOSE_DEVICE_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.debug("Remote didn't close connection within the configured timeout of {} ms, shutting down actively.", (Object)CLOSE_DEVICE_TIMEOUT_MS, (Object)e);
                this.channel.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new PlcConnectionException((Throwable)e);
            }
            if (this.channel.eventLoop().parent() != null) {
                this.channel.eventLoop().parent().shutdownGracefully();
            }
        }
        super.close();
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        return new DefaultPlcReadRequest.Builder((PlcReader)this, (PlcFieldHandler)new S7PlcFieldHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        return new DefaultPlcWriteRequest.Builder((PlcWriter)this, (PlcFieldHandler)new S7PlcFieldHandler());
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        InternalPlcReadRequest internalReadRequest = (InternalPlcReadRequest)this.checkInternal(readRequest, InternalPlcReadRequest.class);
        CompletableFuture future = new CompletableFuture();
        PlcRequestContainer container = new PlcRequestContainer((InternalPlcRequest)internalReadRequest, future);
        this.channel.writeAndFlush((Object)container).addListener(f -> {
            if (!f.isSuccess()) {
                future.completeExceptionally(f.cause());
            }
        });
        return future.thenApply(PlcReadResponse.class::cast);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        InternalPlcWriteRequest internalWriteRequest = (InternalPlcWriteRequest)this.checkInternal(writeRequest, InternalPlcWriteRequest.class);
        CompletableFuture future = new CompletableFuture();
        PlcRequestContainer container = new PlcRequestContainer((InternalPlcRequest)internalWriteRequest, future);
        this.channel.writeAndFlush((Object)container).addListener(f -> {
            if (!f.isSuccess()) {
                future.completeExceptionally(f.cause());
            }
        });
        return future.thenApply(PlcWriteResponse.class::cast);
    }
}

