/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.s7.connection.S7PlcConnection;
import org.apache.plc4x.java.spi.PlcDriver;

public class S7PlcDriver
implements PlcDriver {
    private static final Pattern S7_URI_PATTERN = Pattern.compile("^s7://(?<host>.*)/(?<rack>\\d{1,4})/(?<slot>\\d{1,4})(?<params>\\?.*)?");

    public String getProtocolCode() {
        return "s7";
    }

    public String getProtocolName() {
        return "Siemens S7 (Basic)";
    }

    public PlcConnection connect(String url) throws PlcConnectionException {
        Matcher matcher = S7_URI_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection url doesn't match the format 's7://{host|ip}/{rack}/{slot}'");
        }
        String host = matcher.group("host");
        int rack = Integer.parseInt(matcher.group("rack"));
        int slot = Integer.parseInt(matcher.group("slot"));
        String params = matcher.group("params") != null ? matcher.group("params").substring(1) : null;
        try {
            InetAddress serverInetAddress = InetAddress.getByName(host);
            return new S7PlcConnection(serverInetAddress, rack, slot, params);
        }
        catch (UnknownHostException e) {
            throw new PlcConnectionException("Error parsing address", (Throwable)e);
        }
        catch (Exception e) {
            throw new PlcConnectionException("Error connecting to host", (Throwable)e);
        }
    }

    public PlcConnection connect(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new PlcConnectionException("Basic S7 connections don't support authentication.");
    }
}

