/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.util.Locale;
import org.apache.pivot.wtk.validation.DecimalValidator;

public class FloatValidator
extends DecimalValidator {
    public FloatValidator() {
    }

    public FloatValidator(Locale locale) {
        super(locale);
    }

    @Override
    public boolean isValid(String text) {
        if (!super.isValid(text)) {
            return false;
        }
        Number number = this.parseNumber(text);
        double doubleValue = number.doubleValue();
        if (doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY || Double.isNaN(doubleValue)) {
            return true;
        }
        return !((doubleValue = Math.abs(doubleValue)) > 3.4028234663852886E38) && !(doubleValue < (double)1.4E-45f);
    }
}

