/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.pivot.wtk.validation.FormattedValidator;

public class DecimalValidator
extends FormattedValidator<NumberFormat> {
    private boolean autoTrim = false;

    public DecimalValidator(DecimalFormat format) {
        super(format);
    }

    public DecimalValidator(DecimalFormat format, Locale locale) {
        super(format, locale);
    }

    public DecimalValidator() {
        super(NumberFormat.getInstance());
    }

    public DecimalValidator(Locale locale) {
        super(NumberFormat.getInstance(locale), locale);
    }

    protected final Number parseNumber(String text) {
        try {
            String textToParse = text.toUpperCase(this.locale);
            return ((NumberFormat)this.format).parse(textToParse);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final BigDecimal textToBigDecimal(String text) {
        BigDecimal bd;
        try {
            bd = !this.autoTrim ? new BigDecimal(this.parseNumber(text).toString()) : new BigDecimal(this.parseNumber(text.trim()).toString());
        }
        catch (Exception e) {
            bd = null;
        }
        return bd;
    }

    public void setAutoTrim(boolean autoTrim) {
        this.autoTrim = autoTrim;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }
}

