/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.NodeListener;

public abstract class Node {
    private Element parent = null;
    private int offset = 0;
    private NodeListenerList nodeListeners = new NodeListenerList();

    public Element getParent() {
        return this.parent;
    }

    protected void setParent(Element parent) {
        Element previousParent = this.parent;
        if (previousParent != parent) {
            this.parent = parent;
            this.nodeListeners.parentChanged(this, previousParent);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        int previousOffset = this.offset;
        if (previousOffset != offset) {
            this.offset = offset;
            this.nodeListeners.offsetChanged(this, previousOffset);
        }
    }

    public int getDocumentOffset() {
        return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.offset;
    }

    public abstract void insertRange(Node var1, int var2);

    public abstract Node removeRange(int var1, int var2);

    public Node replaceRange(int offsetArgument, int characterCount, Node range) {
        Node removed = this.removeRange(offsetArgument, characterCount);
        this.insertRange(range, offsetArgument);
        return removed;
    }

    public abstract Node getRange(int var1, int var2);

    public abstract char getCharacterAt(int var1);

    public abstract int getCharacterCount();

    public abstract Node duplicate(boolean var1);

    protected void rangeInserted(int offsetArgument, int characterCount) {
        if (this.parent != null) {
            this.parent.rangeInserted(offsetArgument + this.offset, characterCount);
        }
        this.nodeListeners.rangeInserted(this, offsetArgument, characterCount);
    }

    protected void rangeRemoved(int offsetArgument, int characterCount) {
        if (this.parent != null) {
            this.parent.rangeRemoved(offsetArgument + this.offset, characterCount);
        }
        this.nodeListeners.rangeRemoved(this, offsetArgument, characterCount);
    }

    protected void nodesRemoved(Sequence<Node> removed, int offsetArgument) {
        if (this.parent != null) {
            this.parent.nodesRemoved(removed, offsetArgument + this.offset);
        }
        this.nodeListeners.nodesRemoved(this, removed, offsetArgument);
    }

    protected void nodeInserted(int offsetArgument) {
        if (this.parent != null) {
            this.parent.nodeInserted(offsetArgument + this.offset);
        }
        this.nodeListeners.nodeInserted(this, offsetArgument);
    }

    public ListenerList<NodeListener> getNodeListeners() {
        return this.nodeListeners;
    }

    private static class NodeListenerList
    extends ListenerList<NodeListener>
    implements NodeListener {
        private NodeListenerList() {
        }

        @Override
        public void parentChanged(Node node, Element previousParent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.parentChanged(node, previousParent);
            }
        }

        @Override
        public void offsetChanged(Node node, int previousOffset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.offsetChanged(node, previousOffset);
            }
        }

        @Override
        public void nodeInserted(Node node, int offset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.nodeInserted(node, offset);
            }
        }

        @Override
        public void nodesRemoved(Node node, Sequence<Node> removed, int offset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.nodesRemoved(node, removed, offset);
            }
        }

        @Override
        public void rangeInserted(Node node, int offset, int span) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.rangeInserted(node, offset, span);
            }
        }

        @Override
        public void rangeRemoved(Node node, int offset, int characterCount) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.rangeRemoved(node, offset, characterCount);
            }
        }
    }
}

