/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.text.ComponentNodeListener;
import org.apache.pivot.wtk.text.Node;

public class ComponentNode
extends Node {
    private Component component = null;
    private ComponentNodeListenerList componentNodeListeners = new ComponentNodeListenerList();

    public ComponentNode() {
    }

    public ComponentNode(ComponentNode componentNode) {
        this.setComponent(componentNode.getComponent());
    }

    public ComponentNode(Component component) {
        this.setComponent(component);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        Component previousComponent = this.component;
        if (previousComponent != component) {
            this.component = component;
            this.componentNodeListeners.componentChanged(this, previousComponent);
        }
    }

    @Override
    public char getCharacterAt(int offset) {
        return '\u0000';
    }

    @Override
    public int getCharacterCount() {
        return 1;
    }

    @Override
    public void insertRange(Node range, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeRange(int offset, int span) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getRange(int offset, int characterCount) {
        if (offset < 0 || offset > 1) {
            throw new IndexOutOfBoundsException();
        }
        if (characterCount != 1) {
            throw new IllegalArgumentException("Invalid characterCount.");
        }
        return new ComponentNode(this);
    }

    @Override
    public Node duplicate(boolean recursive) {
        return new ComponentNode(this);
    }

    public ListenerList<ComponentNodeListener> getComponentNodeListeners() {
        return this.componentNodeListeners;
    }

    private static class ComponentNodeListenerList
    extends ListenerList<ComponentNodeListener>
    implements ComponentNodeListener {
        private ComponentNodeListenerList() {
        }

        @Override
        public void componentChanged(ComponentNode componentNode, Component previousComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentNodeListener listener = (ComponentNodeListener)i$.next();
                listener.componentChanged(componentNode, previousComponent);
            }
        }
    }
}

