/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinTextNodeView;
import org.apache.pivot.wtk.text.TextSpan;

class TextPaneSkinSpanView
extends TextPaneSkinElementView {
    public TextPaneSkinSpanView(TextSpan span) {
        super(span);
    }

    @Override
    protected void attach() {
        super.attach();
        TextSpan span = (TextSpan)this.getNode();
        if (span.getLength() > 1) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void childLayout(int breakWidth) {
        if (this.getLength() == 0) {
            this.setSize(0, 0);
        } else {
            TextPaneSkinNodeView nodeView = this.get(0);
            nodeView.layout(breakWidth);
            this.setSize(nodeView.getWidth(), nodeView.getHeight());
        }
    }

    @Override
    public Dimensions getPreferredSize(int breakWidth) {
        if (this.getLength() == 0) {
            return new Dimensions(0, 0);
        }
        TextPaneSkinNodeView nodeView = this.get(0);
        Dimensions childDimensions = nodeView.getPreferredSize(breakWidth);
        return childDimensions;
    }

    @Override
    public int getCharacterCount() {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getCharacterCount();
    }

    public TextPaneSkinTextNodeView getNext() {
        if (this.getLength() == 0) {
            return null;
        }
        return (TextPaneSkinTextNodeView)((TextPaneSkinTextNodeView)this.get(0)).getNext();
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        if (this.getLength() == 0) {
            return -1;
        }
        return this.get(0).getInsertionPoint(x, y);
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        if (this.getLength() == 0) {
            return -1;
        }
        return this.get(0).getNextInsertionPoint(x, from, direction);
    }

    @Override
    public int getRowCount() {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getRowCount();
    }

    @Override
    public int getRowAt(int offset) {
        if (this.getLength() == 0) {
            return 0;
        }
        return this.get(0).getRowAt(offset);
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
        super.setSkinLocation(skinX, skinY);
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.setSkinLocation(skinX, skinY + nodeView.getY());
        }
    }
}

