/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FlowPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class FlowPaneSkin
extends ContainerSkin {
    private HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 2;
    private int verticalSpacing = 2;
    private boolean alignToBaseline = true;

    @Override
    public int getPreferredWidth(int height) {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int preferredWidth = 0;
        int j = 0;
        int n = flowPane.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = flowPane.get(i);
            if (!component.isVisible()) continue;
            preferredWidth += component.getPreferredWidth();
            ++j;
        }
        if (j > 1) {
            preferredWidth += this.horizontalSpacing * (j - 1);
        }
        return preferredWidth += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight;
        FlowPane flowPane = (FlowPane)this.getComponent();
        if (width == -1) {
            if (this.alignToBaseline) {
                Dimensions preferredSize = this.getPreferredSize();
                preferredHeight = preferredSize.height;
            } else {
                preferredHeight = 0;
                int n = flowPane.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = flowPane.get(i);
                    if (!component.isVisible()) continue;
                    preferredHeight = Math.max(preferredHeight, component.getPreferredHeight());
                }
            }
        } else {
            preferredHeight = 0;
            int contentWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
            int rowCount = 0;
            int rowWidth = 0;
            int rowAscent = 0;
            int rowDescent = 0;
            int n = flowPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = flowPane.get(i);
                if (!component.isVisible()) continue;
                Dimensions size = component.getPreferredSize();
                if (rowWidth + size.width > contentWidth && rowWidth > 0) {
                    preferredHeight += rowAscent + rowDescent;
                    ++rowCount;
                    rowWidth = 0;
                    rowAscent = 0;
                    rowDescent = 0;
                }
                rowWidth += size.width + this.horizontalSpacing;
                if (this.alignToBaseline) {
                    int baseline = component.getBaseline(size.width, size.height);
                    rowAscent = Math.max(rowAscent, baseline);
                    rowDescent = Math.max(rowDescent, size.height - baseline);
                    continue;
                }
                rowAscent = Math.max(rowAscent, size.height);
            }
            int lastRowHeight = rowAscent + rowDescent;
            if (lastRowHeight > 0) {
                preferredHeight += lastRowHeight;
                ++rowCount;
            }
            if (rowCount > 0) {
                preferredHeight += this.verticalSpacing * (rowCount - 1);
            }
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int preferredWidth = 0;
        int ascent = 0;
        int descent = 0;
        int j = 0;
        int n = flowPane.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = flowPane.get(i);
            if (!component.isVisible()) continue;
            Dimensions size = component.getPreferredSize();
            preferredWidth += size.width;
            if (this.alignToBaseline) {
                int baseline = component.getBaseline(size.width, size.height);
                ascent = Math.max(ascent, baseline);
                descent = Math.max(descent, size.height - baseline);
            } else {
                ascent = Math.max(ascent, size.height);
            }
            ++j;
        }
        if (j > 1) {
            preferredWidth += this.horizontalSpacing * (j - 1);
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, ascent + descent + this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int width, int height) {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int baseline = -1;
        if (this.alignToBaseline) {
            int contentWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
            int rowWidth = 0;
            int n = flowPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = flowPane.get(i);
                if (!component.isVisible()) continue;
                Dimensions size = component.getPreferredSize();
                if (rowWidth + size.width > contentWidth && rowWidth > 0) break;
                baseline = Math.max(baseline, component.getBaseline(size.width, size.height));
                rowWidth += size.width + this.horizontalSpacing;
            }
            baseline += this.padding.top;
        }
        return baseline;
    }

    @Override
    public void layout() {
        FlowPane flowPane = (FlowPane)this.getComponent();
        int width = this.getWidth();
        int contentWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
        ArrayList rows = new ArrayList();
        ArrayList row = new ArrayList();
        int rowWidth = 0;
        int n = flowPane.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = flowPane.get(i);
            if (!component.isVisible()) continue;
            Dimensions componentSize = component.getPreferredSize();
            component.setSize(componentSize);
            if (rowWidth + componentSize.width > contentWidth && rowWidth > 0) {
                rows.add((Object)row);
                row = new ArrayList();
                rowWidth = 0;
            }
            row.add((Object)component);
            rowWidth += componentSize.width + this.horizontalSpacing;
        }
        if (row.getLength() > 0) {
            rows.add((Object)row);
        }
        int rowY = this.padding.top;
        int n2 = rows.getLength();
        for (int i = 0; i < n2; ++i) {
            row = (ArrayList)rows.get(i);
            rowWidth = 0;
            int rowHeight = 0;
            int baseline = -1;
            for (Component component : row) {
                rowWidth += component.getWidth();
                rowHeight = Math.max(rowHeight, component.getHeight());
                baseline = Math.max(baseline, component.getBaseline(component.getWidth(), component.getHeight()));
            }
            rowWidth += this.horizontalSpacing * (row.getLength() - 1);
            int x = 0;
            switch (this.alignment) {
                case LEFT: {
                    x = this.padding.left;
                    break;
                }
                case CENTER: {
                    x = (width - rowWidth) / 2;
                    break;
                }
                case RIGHT: {
                    x = width - rowWidth - this.padding.right;
                    break;
                }
            }
            for (Component component : row) {
                int componentBaseline = component.getBaseline(component.getWidth(), component.getHeight());
                int y = this.alignToBaseline && baseline != -1 && componentBaseline != -1 ? baseline - componentBaseline : rowHeight - component.getHeight();
                component.setLocation(x, y + rowY);
                x += component.getWidth() + this.horizontalSpacing;
            }
            rowY += rowHeight + this.verticalSpacing;
        }
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("alignment is null.");
        }
        this.alignment = alignment;
        this.invalidateComponent();
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative.");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.invalidateComponent();
    }

    public final void setHorizontalSpacing(Number horizontalSpacing) {
        if (horizontalSpacing == null) {
            throw new IllegalArgumentException("horizontalSpacing is null.");
        }
        this.setHorizontalSpacing(horizontalSpacing.intValue());
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative.");
        }
        this.verticalSpacing = verticalSpacing;
        this.invalidateComponent();
    }

    public final void setVerticalSpacing(Number verticalSpacing) {
        if (verticalSpacing == null) {
            throw new IllegalArgumentException("verticalSpacing is null.");
        }
        this.setVerticalSpacing(verticalSpacing.intValue());
    }

    public boolean getAlignToBaseline() {
        return this.alignToBaseline;
    }

    public void setAlignToBaseline(boolean alignToBaseline) {
        this.alignToBaseline = alignToBaseline;
        this.invalidateComponent();
    }
}

