/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.net.URL;
import org.apache.pivot.wtk.content.TreeBranch;
import org.apache.pivot.wtk.media.Image;

public class TreeNode {
    private TreeBranch parent = null;
    private Image icon = null;
    private String text = null;
    private Object userData = null;

    public TreeNode() {
        this(null, null);
    }

    public TreeNode(Image icon) {
        this(icon, null);
    }

    public TreeNode(String text) {
        this(null, text);
    }

    public TreeNode(Image icon, String text) {
        this.icon = icon;
        this.text = text;
        this.userData = null;
    }

    public TreeBranch getParent() {
        return this.parent;
    }

    protected void setParent(TreeBranch parent) {
        this.parent = parent;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setIcon(URL iconURL) {
        if (iconURL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        this.setIcon(Image.loadFromCache(iconURL));
    }

    public void setIcon(String iconName) {
        if (iconName == null) {
            throw new IllegalArgumentException("iconName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(iconName.substring(1));
        if (url == null) {
            throw new IllegalArgumentException("cannot find icon resource " + iconName);
        }
        this.setIcon(url);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.text);
        sb.append(", ");
        sb.append(this.userData);
        sb.append("]");
        return sb.toString();
    }
}

