/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.media.Image;

public class MenuBarItemDataRenderer
extends BoxPane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();

    public MenuBarItemDataRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("padding", (Object)new Insets(4, 6, 4, 6));
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.getStyles().put("backgroundColor", null);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object data, Button button, boolean highlighted) {
        Image icon = null;
        String text = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            icon = buttonData.getIcon();
        } else if (data instanceof Image) {
            icon = (Image)data;
        }
        text = this.toString(data);
        MenuBar.Item menuBarItem = (MenuBar.Item)button;
        MenuBar menuBar = (MenuBar)menuBarItem.getParent();
        if (icon == null) {
            this.imageView.setVisible(false);
        } else {
            this.imageView.setVisible(true);
            this.imageView.setImage(icon);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
        }
        this.label.setText(text != null ? text : "");
        if (text == null) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
            Font font = (Font)menuBar.getStyles().get("font");
            this.label.getStyles().put("font", (Object)font);
            Color color = button.isEnabled() ? (highlighted ? (Color)menuBar.getStyles().get("activeColor") : (Color)menuBar.getStyles().get("color")) : (Color)menuBar.getStyles().get("disabledColor");
            this.label.getStyles().put("color", (Object)color);
        }
    }

    @Override
    public String toString(Object data) {
        String string = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            string = buttonData.getText();
        } else if (!(data instanceof Image) && data != null) {
            string = data.toString();
        }
        return string;
    }
}

