/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.WindowActionMappingListener;
import org.apache.pivot.wtk.WindowClassListener;
import org.apache.pivot.wtk.WindowListener;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.media.Image;

@DefaultProperty(value="content")
public class Window
extends Container {
    private Window owner = null;
    private ArrayList<Window> ownedWindows = new ArrayList();
    private ArrayList<ActionMapping> actionMappings = new ArrayList();
    private ActionMappingSequence actionMappingSequence = new ActionMappingSequence();
    private HashMap<Keyboard.KeyStroke, Action> actionMap = new HashMap();
    private String title = null;
    private ArrayList<Image> iconImageList = new ArrayList();
    private IconImageSequence iconImageSequence = new IconImageSequence();
    private Component content = null;
    private Component focusDescendant = null;
    private boolean opening = false;
    private boolean closing = false;
    private Point restoreLocation = null;
    private WindowListenerList windowListeners = new WindowListenerList();
    private WindowStateListenerList windowStateListeners = new WindowStateListenerList();
    private WindowActionMappingListenerList windowActionMappingListeners = new WindowActionMappingListenerList();
    private static WindowClassListenerList windowClassListeners = new WindowClassListenerList();
    private static Window activeWindow = null;

    public Window() {
        this(null);
    }

    public Window(Component content) {
        this.setContent(content);
        this.installSkin(Window.class);
    }

    @Override
    protected void setParent(Container parent) {
        if (parent != null && !(parent instanceof Display)) {
            throw new IllegalArgumentException("Window parent must be null or display, cannot be " + parent);
        }
        if (parent == null && this.isActive()) {
            Window.clearActive();
        }
        super.setParent(parent);
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.owner != null && !this.owner.isVisible()) {
            throw new IllegalStateException("Owner is not visible.");
        }
        super.setVisible(visible);
        if (visible && this.isActive()) {
            Window.clearActive();
        }
        for (Window ownedWindow : this.ownedWindows) {
            ownedWindow.setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled && this.isActive()) {
            Window.clearActive();
        }
    }

    public Window getOwner() {
        return this.owner;
    }

    public Window getRootOwner() {
        return this.owner == null ? this : this.owner.getRootOwner();
    }

    public Window getOwnedWindow(int index) {
        return (Window)this.ownedWindows.get(index);
    }

    public int getOwnedWindowCount() {
        return this.ownedWindows.getLength();
    }

    public boolean isOwner(Window window) {
        Window ownerLocal;
        if (window == null) {
            throw new IllegalArgumentException("window is null.");
        }
        for (ownerLocal = window.getOwner(); ownerLocal != null && ownerLocal != this; ownerLocal = ownerLocal.getOwner()) {
        }
        return ownerLocal == this;
    }

    public boolean isOpen() {
        return this.getParent() != null;
    }

    public boolean isOpening() {
        return this.opening;
    }

    public final void open(Display display) {
        this.open(display, null);
    }

    public final void open(Window ownerArgument) {
        if (ownerArgument == null) {
            throw new IllegalArgumentException();
        }
        this.open(ownerArgument.getDisplay(), ownerArgument);
    }

    public void open(Display display, Window ownerArgument) {
        if (display == null) {
            throw new IllegalArgumentException("display is null.");
        }
        if (ownerArgument != null) {
            if (!ownerArgument.isOpen()) {
                throw new IllegalArgumentException("owner is not open.");
            }
            if (this.isOwner(ownerArgument)) {
                throw new IllegalArgumentException("owner is an owned descendant of this window.");
            }
        }
        if (this.isOpen()) {
            if (this.getDisplay() != display) {
                throw new IllegalStateException("Window is already open on a different display.");
            }
            if (this.owner != ownerArgument) {
                throw new IllegalStateException("Window is already open with a different owner.");
            }
        }
        if (!this.isOpen()) {
            this.opening = true;
            Vote vote = this.windowStateListeners.previewWindowOpen(this);
            if (vote == Vote.APPROVE) {
                this.owner = ownerArgument;
                if (ownerArgument != null) {
                    ownerArgument.ownedWindows.add((Object)this);
                }
                display.add(this);
                this.opening = false;
                this.windowStateListeners.windowOpened(this);
                this.moveToFront();
            } else {
                if (vote == Vote.DENY) {
                    this.opening = false;
                }
                this.windowStateListeners.windowOpenVetoed(this, vote);
            }
        }
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closing = true;
            boolean cancel = false;
            for (Window ownedWindow : new ArrayList(this.ownedWindows)) {
                ownedWindow.close();
                cancel |= !ownedWindow.isClosing() && !ownedWindow.isClosed();
            }
            if (cancel) {
                this.closing = false;
            } else {
                Vote vote = this.windowStateListeners.previewWindowClose(this);
                if (vote == Vote.APPROVE) {
                    Display display = this.getDisplay();
                    display.remove(this);
                    Window ownerLocal = this.owner;
                    this.owner = null;
                    if (ownerLocal != null) {
                        ownerLocal.ownedWindows.remove((Object)this);
                    }
                    this.closing = false;
                    this.windowStateListeners.windowClosed(this, display, ownerLocal);
                } else {
                    if (vote == Vote.DENY) {
                        this.closing = false;
                    }
                    this.windowStateListeners.windowCloseVetoed(this, vote);
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String previousTitle = this.title;
        if (previousTitle != title) {
            this.title = title;
            this.windowListeners.titleChanged(this, previousTitle);
        }
    }

    public IconImageSequence getIcons() {
        return this.iconImageSequence;
    }

    public void setIcon(URL iconURL) {
        if (iconURL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        Image icon = Image.loadFromCache(iconURL);
        this.getIcons().remove(0, this.getIcons().getLength());
        this.getIcons().add(icon);
    }

    public void setIcon(String iconName) {
        if (iconName == null) {
            throw new IllegalArgumentException("iconName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(iconName.substring(1));
        if (url == null) {
            throw new IllegalArgumentException("cannot find icon resource " + iconName);
        }
        this.setIcon(url);
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Component previousContent = this.content;
        if (content != previousContent) {
            this.content = null;
            if (previousContent != null) {
                this.remove(previousContent);
            }
            if (content != null) {
                this.insert(content, 0);
            }
            this.content = content;
            this.windowListeners.contentChanged(this, previousContent);
        }
    }

    public Bounds getClientArea() {
        Skin windowSkin = (Skin)this.getSkin();
        return windowSkin.getClientArea();
    }

    public boolean isActive() {
        return activeWindow == this;
    }

    public boolean requestActive() {
        if (this.isOpen() && this.isVisible() && this.isEnabled()) {
            Window.setActiveWindow(this);
        }
        return this.isActive();
    }

    protected void setActive(boolean active, Window obverseWindow) {
        this.windowListeners.activeChanged(this, obverseWindow);
    }

    public static Window getActiveWindow() {
        return activeWindow;
    }

    private static void setActiveWindow(Window activeWindow) {
        Window previousActiveWindow = Window.activeWindow;
        if (previousActiveWindow != activeWindow) {
            Window.activeWindow = activeWindow;
            if (previousActiveWindow != null) {
                previousActiveWindow.setActive(false, activeWindow);
            }
            if (activeWindow != null) {
                activeWindow.setActive(true, previousActiveWindow);
            }
            windowClassListeners.activeWindowChanged(previousActiveWindow);
        }
    }

    public static void clearActive() {
        if (activeWindow != null) {
            Window.setActiveWindow(Window.activeWindow.owner);
        }
    }

    public Component getFocusDescendant() {
        return this.focusDescendant;
    }

    public void clearFocusDescendant() {
        this.focusDescendant = null;
    }

    @Override
    protected void descendantGainedFocus(Component descendant, Component previousFocusedComponent) {
        this.focusDescendant = descendant;
        super.descendantGainedFocus(descendant, previousFocusedComponent);
    }

    @Override
    protected void descendantRemoved(Component descendant) {
        super.descendantRemoved(descendant);
        if (descendant == this.focusDescendant) {
            this.focusDescendant = null;
        }
    }

    public ActionMappingSequence getActionMappings() {
        return this.actionMappingSequence;
    }

    public boolean isTopMost() {
        Display display = this.getDisplay();
        return display.get(display.getLength() - 1) == this;
    }

    public boolean isBottomMost() {
        Display display = this.getDisplay();
        return display.get(0) == this;
    }

    public void moveToFront() {
        int ownedWindowCount;
        if (!this.isOpen()) {
            throw new IllegalStateException("Window is not open.");
        }
        Display display = this.getDisplay();
        int top = display.getLength() - 1;
        int i = display.indexOf(this);
        if (i < top) {
            display.move(i, top);
        }
        if ((ownedWindowCount = this.ownedWindows.getLength()) == 0) {
            if (this.isShowing() && this.isEnabled() && this.focusDescendant != null) {
                this.focusDescendant.requestFocus();
            }
        } else {
            ArrayList ownedWindowIndexes = new ArrayList(ownedWindowCount);
            for (Window ownedWindow : this.ownedWindows) {
                if (!ownedWindow.isOpen()) continue;
                ownedWindowIndexes.add((Object)display.indexOf(ownedWindow));
            }
            ArrayList.sort((ArrayList)ownedWindowIndexes);
            ArrayList sortedOwnedWindows = new ArrayList(this.ownedWindows.getLength());
            for (Integer index : ownedWindowIndexes) {
                sortedOwnedWindows.add((Object)((Window)display.get(index)));
            }
            for (Window ownedWindow : sortedOwnedWindows) {
                ownedWindow.moveToFront();
            }
        }
    }

    public void moveToBack() {
        Display display;
        int i;
        if (!this.isOpen()) {
            throw new IllegalStateException("Window is not open.");
        }
        if (this.isActive()) {
            Window.clearActive();
        }
        if (this.containsFocus()) {
            Window.clearFocus();
        }
        if ((i = (display = this.getDisplay()).indexOf(this)) > 0) {
            display.move(i, 0);
        }
        if (this.owner != null) {
            this.owner.moveToBack();
        }
    }

    public boolean isMaximized() {
        return this.restoreLocation != null;
    }

    public void setMaximized(boolean maximized) {
        if (maximized != this.isMaximized()) {
            if (maximized) {
                this.restoreLocation = this.getLocation();
                this.setLocation(0, 0);
            } else {
                this.setLocation(this.restoreLocation.x, this.restoreLocation.y);
                this.restoreLocation = null;
            }
            this.invalidate();
            this.windowListeners.maximizedChanged(this);
        }
    }

    public void align(Bounds bounds, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.align(bounds, horizontalAlignment, 0, verticalAlignment, 0);
    }

    public void align(Bounds bounds, HorizontalAlignment horizontalAlignment, int horizontalOffset, VerticalAlignment verticalAlignment, int verticalOffset) {
        int x = 0;
        int y = 0;
        Dimensions size = this.getSize();
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            x = bounds.x - size.width;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            x = bounds.x + bounds.width - size.width;
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            x = bounds.x + (int)Math.round((double)(bounds.width - size.width) / 2.0);
        } else {
            throw new IllegalArgumentException("Unsupported horizontal alignment.");
        }
        x += horizontalOffset;
        if (verticalAlignment == VerticalAlignment.TOP) {
            y = bounds.y - size.height;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            y = bounds.y + bounds.height;
        } else if (verticalAlignment == VerticalAlignment.CENTER) {
            y = bounds.y + (int)Math.round((double)(bounds.height - size.height) / 2.0);
        } else {
            throw new IllegalArgumentException("Unsupported vertical alignment.");
        }
        this.setLocation(x, y += verticalOffset);
    }

    @Override
    public boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(keyCode, keyLocation);
        Keyboard.KeyStroke keyStroke = new Keyboard.KeyStroke(keyCode, Keyboard.getModifiers());
        Action action = (Action)this.actionMap.get((Object)keyStroke);
        if (action != null && action.isEnabled()) {
            action.perform(this);
        }
        return consumed;
    }

    public ListenerList<WindowListener> getWindowListeners() {
        return this.windowListeners;
    }

    public ListenerList<WindowStateListener> getWindowStateListeners() {
        return this.windowStateListeners;
    }

    public ListenerList<WindowActionMappingListener> getWindowActionMappingListeners() {
        return this.windowActionMappingListeners;
    }

    public static ListenerList<WindowClassListener> getWindowClassListeners() {
        return windowClassListeners;
    }

    private static class WindowClassListenerList
    extends WTKListenerList<WindowClassListener>
    implements WindowClassListener {
        private WindowClassListenerList() {
        }

        @Override
        public void activeWindowChanged(Window previousActiveWindow) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowClassListener listener = (WindowClassListener)i$.next();
                listener.activeWindowChanged(previousActiveWindow);
            }
        }
    }

    private static class WindowActionMappingListenerList
    extends WTKListenerList<WindowActionMappingListener>
    implements WindowActionMappingListener {
        private WindowActionMappingListenerList() {
        }

        @Override
        public void actionMappingAdded(Window window) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowActionMappingListener listener = (WindowActionMappingListener)i$.next();
                listener.actionMappingAdded(window);
            }
        }

        @Override
        public void actionMappingsRemoved(Window window, int index, Sequence<ActionMapping> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowActionMappingListener listener = (WindowActionMappingListener)i$.next();
                listener.actionMappingsRemoved(window, index, removed);
            }
        }

        @Override
        public void keyStrokeChanged(ActionMapping actionMapping, Keyboard.KeyStroke previousKeyStroke) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowActionMappingListener listener = (WindowActionMappingListener)i$.next();
                listener.keyStrokeChanged(actionMapping, previousKeyStroke);
            }
        }

        @Override
        public void actionChanged(ActionMapping actionMapping, Action previousAction) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowActionMappingListener listener = (WindowActionMappingListener)i$.next();
                listener.actionChanged(actionMapping, previousAction);
            }
        }
    }

    private static class WindowStateListenerList
    extends WTKListenerList<WindowStateListener>
    implements WindowStateListener {
        private WindowStateListenerList() {
        }

        @Override
        public void windowOpened(Window window) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                listener.windowOpened(window);
            }
        }

        @Override
        public Vote previewWindowClose(Window window) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                vote = vote.tally(listener.previewWindowClose(window));
            }
            return vote;
        }

        @Override
        public void windowCloseVetoed(Window window, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                listener.windowCloseVetoed(window, reason);
            }
        }

        @Override
        public Vote previewWindowOpen(Window window) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                vote = vote.tally(listener.previewWindowOpen(window));
            }
            return vote;
        }

        @Override
        public void windowOpenVetoed(Window window, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                listener.windowOpenVetoed(window, reason);
            }
        }

        @Override
        public void windowClosed(Window window, Display display, Window owner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowStateListener listener = (WindowStateListener)i$.next();
                listener.windowClosed(window, display, owner);
            }
        }
    }

    private static class WindowListenerList
    extends WTKListenerList<WindowListener>
    implements WindowListener {
        private WindowListenerList() {
        }

        @Override
        public void titleChanged(Window window, String previousTitle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.titleChanged(window, previousTitle);
            }
        }

        @Override
        public void iconAdded(Window window, Image addedIcon) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.iconAdded(window, addedIcon);
            }
        }

        @Override
        public void iconInserted(Window window, Image addedIcon, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.iconInserted(window, addedIcon, index);
            }
        }

        @Override
        public void iconsRemoved(Window window, int index, Sequence<Image> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.iconsRemoved(window, index, removed);
            }
        }

        @Override
        public void contentChanged(Window window, Component previousContent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.contentChanged(window, previousContent);
            }
        }

        @Override
        public void activeChanged(Window window, Window obverseWindow) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.activeChanged(window, obverseWindow);
            }
        }

        @Override
        public void maximizedChanged(Window window) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                WindowListener listener = (WindowListener)i$.next();
                listener.maximizedChanged(window);
            }
        }
    }

    public class IconImageSequence
    implements Sequence<Image>,
    Iterable<Image> {
        public int add(Image image) {
            int index = Window.this.iconImageList.add((Object)image);
            Window.this.windowListeners.iconAdded(Window.this, image);
            return index;
        }

        public void insert(Image image, int index) {
            Window.this.iconImageList.insert((Object)image, index);
            Window.this.windowListeners.iconInserted(Window.this, image, index);
        }

        public Image update(int index, Image image) {
            throw new UnsupportedOperationException();
        }

        public int remove(Image image) {
            int index = this.indexOf(image);
            if (index >= 0) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Image> remove(int index, int count) {
            Sequence removed = Window.this.iconImageList.remove(index, count);
            Window.this.windowListeners.iconsRemoved(Window.this, index, (Sequence<Image>)removed);
            return removed;
        }

        public Image get(int index) {
            return (Image)Window.this.iconImageList.get(index);
        }

        public int indexOf(Image image) {
            return Window.this.iconImageList.indexOf((Object)image);
        }

        public int getLength() {
            return Window.this.iconImageList.getLength();
        }

        @Override
        public Iterator<Image> iterator() {
            return new ImmutableIterator((Iterator)Window.this.iconImageList.iterator());
        }
    }

    public class ActionMappingSequence
    implements Sequence<ActionMapping> {
        public int add(ActionMapping actionMapping) {
            if (actionMapping.window != null) {
                throw new IllegalArgumentException("Action mapping already has a window.");
            }
            if (actionMapping.keyStroke == null) {
                throw new IllegalArgumentException("Keystroke is undefined.");
            }
            if (actionMapping.action == null) {
                throw new IllegalArgumentException("Action is undefined.");
            }
            if (Window.this.actionMap.containsKey((Object)actionMapping.keyStroke)) {
                throw new IllegalArgumentException("A mapping for " + actionMapping.keyStroke + " already exists.");
            }
            actionMapping.window = Window.this;
            int index = Window.this.actionMappings.add((Object)actionMapping);
            Window.this.actionMap.put((Object)actionMapping.keyStroke, (Object)actionMapping.action);
            Window.this.windowActionMappingListeners.actionMappingAdded(Window.this);
            return index;
        }

        public void insert(ActionMapping actionMapping, int index) {
            throw new UnsupportedOperationException();
        }

        public ActionMapping update(int index, ActionMapping actionMapping) {
            throw new UnsupportedOperationException();
        }

        public int remove(ActionMapping actionMapping) {
            int index = this.indexOf(actionMapping);
            if (index >= 0) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<ActionMapping> remove(int index, int count) {
            Sequence removed = Window.this.actionMappings.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                ActionMapping actionMapping = (ActionMapping)removed.get(i);
                actionMapping.window = null;
                Window.this.actionMap.remove((Object)actionMapping.keyStroke);
            }
            Window.this.windowActionMappingListeners.actionMappingsRemoved(Window.this, index, (Sequence<ActionMapping>)removed);
            return removed;
        }

        public ActionMapping get(int index) {
            return (ActionMapping)Window.this.actionMappings.get(index);
        }

        public int indexOf(ActionMapping actionMapping) {
            return Window.this.actionMappings.indexOf((Object)actionMapping);
        }

        public int getLength() {
            return Window.this.actionMappings.getLength();
        }
    }

    public static class ActionMapping {
        private Window window = null;
        private Keyboard.KeyStroke keyStroke = null;
        private Action action = null;

        public ActionMapping() {
        }

        public ActionMapping(Keyboard.KeyStroke keyStroke, Action action) {
            this.setKeyStroke(keyStroke);
            this.setAction(action);
        }

        public ActionMapping(Keyboard.KeyStroke keyStroke, String actionID) {
            this.setKeyStroke(keyStroke);
            this.setAction(actionID);
        }

        public Window getWindow() {
            return this.window;
        }

        public Keyboard.KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public void setKeyStroke(Keyboard.KeyStroke keyStroke) {
            Keyboard.KeyStroke previousKeyStroke = this.keyStroke;
            if (keyStroke != previousKeyStroke) {
                if (this.window != null) {
                    if (keyStroke == null) {
                        throw new IllegalStateException();
                    }
                    if (this.window.actionMap.containsKey((Object)keyStroke)) {
                        throw new IllegalArgumentException("A mapping for " + keyStroke + " already exists.");
                    }
                    if (previousKeyStroke != null) {
                        this.window.actionMap.remove((Object)previousKeyStroke);
                    }
                    this.window.actionMap.put((Object)keyStroke, (Object)this.action);
                    this.window.windowActionMappingListeners.keyStrokeChanged(this, previousKeyStroke);
                }
                this.keyStroke = keyStroke;
            }
        }

        public void setKeyStroke(String keyStroke) {
            if (keyStroke == null) {
                throw new IllegalArgumentException("keyStroke is null.");
            }
            this.setKeyStroke(Keyboard.KeyStroke.decode(keyStroke));
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            Action previousAction = this.action;
            if (action != previousAction) {
                if (this.window != null) {
                    if (action == null) {
                        throw new IllegalStateException();
                    }
                    this.window.actionMap.put((Object)this.keyStroke, (Object)action);
                    this.window.windowActionMappingListeners.actionChanged(this, previousAction);
                }
                this.action = action;
            }
        }

        public void setAction(String actionID) {
            if (actionID == null) {
                throw new IllegalArgumentException("actionID is null");
            }
            Action actionLocal = Action.getNamedActions().get(actionID);
            if (actionLocal == null) {
                throw new IllegalArgumentException("An action with ID " + actionID + " does not exist.");
            }
            this.setAction(actionLocal);
        }
    }

    public static interface Skin
    extends org.apache.pivot.wtk.Skin {
        public Bounds getClientArea();
    }
}

