/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextInputBindingListener;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.TextInputListener;
import org.apache.pivot.wtk.TextInputSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.validation.Validator;

public class TextInput
extends Component {
    private StringBuilder characters = new StringBuilder();
    private int selectionStart = 0;
    private int selectionLength = 0;
    private int textSize = 16;
    private int maximumLength = Short.MAX_VALUE;
    private boolean password = false;
    private String prompt = null;
    private boolean editable = true;
    private String textKey = null;
    private BindType textBindType = BindType.BOTH;
    private TextBindMapping textBindMapping = null;
    private Validator validator = null;
    private boolean strictValidation = false;
    private boolean textValid = true;
    private LinkedList<Edit> editHistory = new LinkedList();
    private TextInputListenerList textInputListeners = new TextInputListenerList();
    private TextInputContentListenerList textInputContentListeners = new TextInputContentListenerList();
    private TextInputSelectionListenerList textInputSelectionListeners = new TextInputSelectionListenerList();
    private TextInputBindingListenerList textInputBindingListeners = new TextInputBindingListenerList();
    public static final int DEFAULT_TEXT_SIZE = 16;
    private static final int MAXIMUM_EDIT_HISTORY_LENGTH = 30;

    public TextInput() {
        this.installSkin(TextInput.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public String getText() {
        return this.getText(0, this.getCharacterCount());
    }

    public String getText(int beginIndex, int endIndex) {
        return this.characters.substring(beginIndex, endIndex);
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (text.length() > this.maximumLength) {
            throw new IllegalArgumentException("Text length is greater than maximum length.");
        }
        this.characters = new StringBuilder(text);
        int previousSelectionStart = this.selectionStart;
        int previousSelectionLength = this.selectionLength;
        this.selectionStart = text.length();
        this.selectionLength = 0;
        boolean previousTextValid = this.textValid;
        this.textValid = this.validator == null ? true : this.validator.isValid(text);
        this.editHistory.clear();
        this.textInputContentListeners.textChanged(this);
        if (this.textValid != previousTextValid) {
            this.textInputListeners.textValidChanged(this);
        }
        if (this.selectionStart != previousSelectionStart || this.selectionLength != previousSelectionLength) {
            this.textInputSelectionListeners.selectionChanged(this, this.selectionStart, this.selectionLength);
        }
    }

    public void insertText(CharSequence text, int index) {
        this.insertText(text, index, true);
    }

    private void insertText(CharSequence text, int index, boolean addToEditHistory) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (this.characters.length() + text.length() > this.maximumLength) {
            throw new IllegalArgumentException("Insertion of text would exceed maximum length.");
        }
        if (text.length() > 0) {
            Vote vote = this.textInputContentListeners.previewInsertText(this, text, index);
            if (vote == Vote.APPROVE) {
                this.characters.insert(index, text);
                if (addToEditHistory) {
                    this.addHistoryItem(new InsertTextEdit(text, index));
                }
                int previousSelectionStart = this.selectionStart;
                int previousSelectionLength = this.selectionLength;
                this.selectionStart = index + text.length();
                this.selectionLength = 0;
                boolean previousTextValid = this.textValid;
                this.textValid = this.validator == null ? true : this.validator.isValid(this.getText());
                this.textInputContentListeners.textInserted(this, index, text.length());
                this.textInputContentListeners.textChanged(this);
                if (this.textValid != previousTextValid) {
                    this.textInputListeners.textValidChanged(this);
                }
                if (this.selectionStart != previousSelectionStart || this.selectionLength != previousSelectionLength) {
                    this.textInputSelectionListeners.selectionChanged(this, this.selectionStart, this.selectionLength);
                }
            } else {
                this.textInputContentListeners.insertTextVetoed(this, vote);
            }
        }
    }

    public void removeText(int index, int count) {
        this.removeText(index, count, true);
    }

    private void removeText(int index, int count, boolean addToEditHistory) {
        if (count > 0) {
            Vote vote = this.textInputContentListeners.previewRemoveText(this, index, count);
            if (vote == Vote.APPROVE) {
                if (addToEditHistory) {
                    this.addHistoryItem(new RemoveTextEdit(index, count));
                }
                this.characters.delete(index, index + count);
                int previousSelectionStart = this.selectionStart;
                int previousSelectionLength = this.selectionLength;
                this.selectionStart = index;
                this.selectionLength = 0;
                boolean previousTextValid = this.textValid;
                this.textValid = this.validator == null ? true : this.validator.isValid(this.getText());
                this.textInputContentListeners.textRemoved(this, index, count);
                this.textInputContentListeners.textChanged(this);
                if (this.textValid != previousTextValid) {
                    this.textInputListeners.textValidChanged(this);
                }
                if (this.selectionStart != previousSelectionStart || this.selectionLength != previousSelectionLength) {
                    this.textInputSelectionListeners.selectionChanged(this, this.selectionStart, this.selectionLength);
                }
            } else {
                this.textInputContentListeners.removeTextVetoed(this, vote);
            }
        }
    }

    public CharSequence getCharacters() {
        return this.characters;
    }

    public char getCharacterAt(int index) {
        return this.characters.charAt(index);
    }

    public int getCharacterCount() {
        return this.characters.length();
    }

    public void cut() {
        this.copy();
        this.removeText(this.selectionStart, this.selectionLength);
    }

    public void copy() {
        String selectedText = this.getSelectedText();
        if (selectedText.length() > 0) {
            LocalManifest clipboardContent = new LocalManifest();
            clipboardContent.putText(selectedText);
            Clipboard.setContent(clipboardContent);
        }
    }

    public void paste() {
        Manifest clipboardContent = Clipboard.getContent();
        if (clipboardContent != null && clipboardContent.containsText()) {
            String text = null;
            try {
                text = clipboardContent.getText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (text != null) {
                if (this.characters.length() + text.length() > this.maximumLength) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.removeText(this.selectionStart, this.selectionLength);
                    this.insertText(text, this.selectionStart);
                }
            }
        }
    }

    public void undo() {
        int n = this.editHistory.getLength();
        if (n > 0) {
            Edit edit = (Edit)this.editHistory.remove(n - 1, 1).get(0);
            edit.undo();
        }
    }

    private void addHistoryItem(Edit edit) {
        this.editHistory.add((Object)edit);
        if (this.editHistory.getLength() > 30) {
            this.editHistory.remove(0, 1);
        }
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public Span getSelection() {
        return this.selectionLength == 0 ? null : new Span(this.selectionStart, this.selectionStart + this.selectionLength - 1);
    }

    public void setSelection(int selectionStart, int selectionLength) {
        if (selectionLength < 0) {
            throw new IllegalArgumentException("selectionLength is negative.");
        }
        if (selectionStart < 0 || selectionStart + selectionLength > this.characters.length()) {
            throw new IndexOutOfBoundsException();
        }
        int previousSelectionStart = this.selectionStart;
        int previousSelectionLength = this.selectionLength;
        if (previousSelectionStart != selectionStart || previousSelectionLength != selectionLength) {
            this.selectionStart = selectionStart;
            this.selectionLength = selectionLength;
            this.textInputSelectionListeners.selectionChanged(this, previousSelectionStart, previousSelectionLength);
        }
    }

    public final void setSelection(Span selection) {
        if (selection == null) {
            throw new IllegalArgumentException("selection is null.");
        }
        this.setSelection(Math.min(selection.start, selection.end), (int)selection.getLength());
    }

    public void selectAll() {
        this.setSelection(0, this.characters.length());
    }

    public void clearSelection() {
        this.setSelection(0, 0);
    }

    public String getSelectedText() {
        return this.getText(this.selectionStart, this.selectionStart + this.selectionLength);
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        if (textSize < 0) {
            throw new IllegalArgumentException("textSize is negative.");
        }
        int previousTextSize = this.textSize;
        if (previousTextSize != textSize) {
            this.textSize = textSize;
            this.textInputListeners.textSizeChanged(this, previousTextSize);
        }
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        if (maximumLength < 0) {
            throw new IllegalArgumentException("maximumLength is negative.");
        }
        int previousMaximumLength = this.maximumLength;
        if (previousMaximumLength != maximumLength) {
            this.maximumLength = maximumLength;
            int length = this.characters.length();
            if (length > maximumLength) {
                int count = length - maximumLength;
                this.characters.delete(maximumLength, length);
                this.textInputContentListeners.textRemoved(this, maximumLength, count);
                this.textInputContentListeners.textChanged(this);
            }
            this.textInputListeners.maximumLengthChanged(this, previousMaximumLength);
        }
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        if (this.password != password) {
            this.password = password;
            this.textInputListeners.passwordChanged(this);
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        String previousPrompt = this.prompt;
        if (previousPrompt != prompt) {
            this.prompt = prompt;
            this.textInputListeners.promptChanged(this, previousPrompt);
        }
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String textKey) {
        String previousTextKey = this.textKey;
        if (previousTextKey != textKey) {
            this.textKey = textKey;
            this.textInputBindingListeners.textKeyChanged(this, previousTextKey);
        }
    }

    public BindType getTextBindType() {
        return this.textBindType;
    }

    public void setTextBindType(BindType textBindType) {
        if (textBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousTextBindType = this.textBindType;
        if (previousTextBindType != textBindType) {
            this.textBindType = textBindType;
            this.textInputBindingListeners.textBindTypeChanged(this, previousTextBindType);
        }
    }

    public TextBindMapping getTextBindMapping() {
        return this.textBindMapping;
    }

    public void setTextBindMapping(TextBindMapping textBindMapping) {
        TextBindMapping previousTextBindMapping = this.textBindMapping;
        if (previousTextBindMapping != textBindMapping) {
            this.textBindMapping = textBindMapping;
            this.textInputBindingListeners.textBindMappingChanged(this, previousTextBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.textKey != null && JSON.containsKey((Object)context, (String)this.textKey) && this.textBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.textKey);
            value = this.textBindMapping == null ? (value == null ? "" : value.toString()) : this.textBindMapping.toString(value);
            this.setText((String)value);
        }
    }

    @Override
    public void store(Object context) {
        if (this.textKey != null && this.textBindType != BindType.LOAD) {
            String text = this.getText();
            JSON.put((Object)context, (String)this.textKey, (Object)(this.textBindMapping == null ? text : this.textBindMapping.valueOf(text)));
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText("");
        }
    }

    public int getInsertionPoint(int x) {
        Skin textInputSkin = (Skin)((Object)this.getSkin());
        return textInputSkin.getInsertionPoint(x);
    }

    public Bounds getCharacterBounds(int index) {
        Skin textInputSkin = (Skin)((Object)this.getSkin());
        return textInputSkin.getCharacterBounds(index);
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        Validator previousValidator = this.validator;
        if (validator != previousValidator) {
            this.validator = validator;
            boolean previousTextValid = this.textValid;
            this.textValid = validator == null ? true : validator.isValid(this.getText());
            this.textInputListeners.textValidatorChanged(this, previousValidator);
            if (this.textValid != previousTextValid) {
                this.textInputListeners.textValidChanged(this);
            }
        }
    }

    public boolean isStrictValidation() {
        return this.strictValidation;
    }

    public void setStrictValidation(boolean strictValidation) {
        if (this.strictValidation != strictValidation) {
            this.strictValidation = strictValidation;
            this.textInputListeners.strictValidationChanged(this);
        }
    }

    public boolean isTextValid() {
        return this.textValid;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            if (!editable && this.isFocused()) {
                TextInput.clearFocus();
            }
            this.editable = editable;
            this.textInputListeners.editableChanged(this);
        }
    }

    public ListenerList<TextInputListener> getTextInputListeners() {
        return this.textInputListeners;
    }

    public ListenerList<TextInputContentListener> getTextInputContentListeners() {
        return this.textInputContentListeners;
    }

    public ListenerList<TextInputSelectionListener> getTextInputSelectionListeners() {
        return this.textInputSelectionListeners;
    }

    public ListenerList<TextInputBindingListener> getTextInputBindingListeners() {
        return this.textInputBindingListeners;
    }

    private static class TextInputBindingListenerList
    extends WTKListenerList<TextInputBindingListener>
    implements TextInputBindingListener {
        private TextInputBindingListenerList() {
        }

        @Override
        public void textKeyChanged(TextInput textInput, String previousTextKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputBindingListener listener = (TextInputBindingListener)i$.next();
                listener.textKeyChanged(textInput, previousTextKey);
            }
        }

        @Override
        public void textBindTypeChanged(TextInput textInput, BindType previousTextBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputBindingListener listener = (TextInputBindingListener)i$.next();
                listener.textBindTypeChanged(textInput, previousTextBindType);
            }
        }

        @Override
        public void textBindMappingChanged(TextInput textInput, TextBindMapping previousTextBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputBindingListener listener = (TextInputBindingListener)i$.next();
                listener.textBindMappingChanged(textInput, previousTextBindMapping);
            }
        }
    }

    private static class TextInputSelectionListenerList
    extends WTKListenerList<TextInputSelectionListener>
    implements TextInputSelectionListener {
        private TextInputSelectionListenerList() {
        }

        @Override
        public void selectionChanged(TextInput textInput, int previousSelectionStart, int previousSelectionLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputSelectionListener listener = (TextInputSelectionListener)i$.next();
                listener.selectionChanged(textInput, previousSelectionStart, previousSelectionLength);
            }
        }
    }

    private static class TextInputContentListenerList
    extends WTKListenerList<TextInputContentListener>
    implements TextInputContentListener {
        private TextInputContentListenerList() {
        }

        @Override
        public Vote previewInsertText(TextInput textInput, CharSequence text, int index) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                vote = vote.tally(listener.previewInsertText(textInput, text, index));
            }
            return vote;
        }

        @Override
        public void insertTextVetoed(TextInput textInput, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                listener.insertTextVetoed(textInput, reason);
            }
        }

        @Override
        public void textInserted(TextInput textInput, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                listener.textInserted(textInput, index, count);
            }
        }

        @Override
        public Vote previewRemoveText(TextInput textInput, int index, int count) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                vote = vote.tally(listener.previewRemoveText(textInput, index, count));
            }
            return vote;
        }

        @Override
        public void removeTextVetoed(TextInput textInput, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                listener.removeTextVetoed(textInput, reason);
            }
        }

        @Override
        public void textRemoved(TextInput textInput, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                listener.textRemoved(textInput, index, count);
            }
        }

        @Override
        public void textChanged(TextInput textInput) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputContentListener listener = (TextInputContentListener)i$.next();
                listener.textChanged(textInput);
            }
        }
    }

    private static class TextInputListenerList
    extends WTKListenerList<TextInputListener>
    implements TextInputListener {
        private TextInputListenerList() {
        }

        @Override
        public void textSizeChanged(TextInput textInput, int previousTextSize) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.textSizeChanged(textInput, previousTextSize);
            }
        }

        @Override
        public void maximumLengthChanged(TextInput textInput, int previousMaximumLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.maximumLengthChanged(textInput, previousMaximumLength);
            }
        }

        @Override
        public void passwordChanged(TextInput textInput) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.passwordChanged(textInput);
            }
        }

        @Override
        public void promptChanged(TextInput textInput, String previousPrompt) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.promptChanged(textInput, previousPrompt);
            }
        }

        @Override
        public void textValidatorChanged(TextInput textInput, Validator previousValidator) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.textValidatorChanged(textInput, previousValidator);
            }
        }

        @Override
        public void strictValidationChanged(TextInput textInput) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.strictValidationChanged(textInput);
            }
        }

        @Override
        public void textValidChanged(TextInput textInput) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.textValidChanged(textInput);
            }
        }

        @Override
        public void editableChanged(TextInput textInput) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextInputListener listener = (TextInputListener)i$.next();
                listener.editableChanged(textInput);
            }
        }
    }

    private class RemoveTextEdit
    implements Edit {
        private final int index;
        private final String text;

        public RemoveTextEdit(int index, int count) {
            this.index = index;
            this.text = TextInput.this.getText(index, index + count);
        }

        @Override
        public void undo() {
            TextInput.this.insertText(this.text, this.index, false);
        }
    }

    private class InsertTextEdit
    implements Edit {
        private final int index;
        private final int count;

        public InsertTextEdit(CharSequence text, int index) {
            this.index = index;
            this.count = text.length();
        }

        @Override
        public void undo() {
            TextInput.this.removeText(this.index, this.count, false);
        }
    }

    private static interface Edit {
        public void undo();
    }

    public static interface TextBindMapping {
        public String toString(Object var1);

        public Object valueOf(String var1);
    }

    public static interface Skin {
        public int getInsertionPoint(int var1);

        public Bounds getCharacterBounds(int var1);
    }
}

