/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;

public class RadioButtonGroup
extends ButtonGroup {
    private final ComponentKeyListener componentKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            int modifiers = Keyboard.getModifiers();
            boolean handled = false;
            if (!RadioButtonGroup.this.intraGroupFocusTransferEnabled && keyCode == 9) {
                if (modifiers == 0) {
                    Button lastFocusableButton = RadioButtonGroup.this.get(RadioButtonGroup.this.findPrevious(RadioButtonGroup.this.buttonOrder.getLength()));
                    lastFocusableButton.transferFocus(FocusTraversalDirection.FORWARD);
                    handled = true;
                } else if (modifiers == Keyboard.Modifier.SHIFT.getMask()) {
                    Button firstFocusableButton = RadioButtonGroup.this.get(RadioButtonGroup.this.findNext(-1));
                    firstFocusableButton.transferFocus(FocusTraversalDirection.BACKWARD);
                    handled = true;
                }
            }
            if (!handled && modifiers == 0) {
                RadioButtonGroup radioButtonGroup = RadioButtonGroup.this;
                Button selectedButton = radioButtonGroup.getSelection();
                handled = true;
                if (keyCode == 36) {
                    radioButtonGroup.selectFirstButton();
                } else if (keyCode == 35) {
                    radioButtonGroup.selectLastButton();
                } else if (keyCode == 37 || keyCode == 38) {
                    radioButtonGroup.selectPreviousButton(selectedButton);
                } else if (keyCode == 39 || keyCode == 40) {
                    radioButtonGroup.selectNextButton(selectedButton);
                } else {
                    handled = false;
                }
            }
            return handled;
        }

        @Override
        public boolean keyTyped(Component component, char character) {
            boolean shiftPressed;
            int modifiers = Keyboard.getModifiers();
            boolean handled = false;
            boolean noModifiersPressed = modifiers == 0;
            boolean bl = shiftPressed = modifiers == Keyboard.Modifier.SHIFT.getMask();
            if (noModifiersPressed || shiftPressed) {
                RadioButtonGroup radioButtonGroup = RadioButtonGroup.this;
                Button selectedButton = radioButtonGroup.getSelection();
                RadioButtonGroup.this.firstCharacterFilter.setTarget(character);
                int searchStartIndex = selectedButton != null ? radioButtonGroup.indexOf(selectedButton) : (noModifiersPressed ? -1 : RadioButtonGroup.this.buttonOrder.getLength());
                int result = -1;
                if (noModifiersPressed) {
                    result = radioButtonGroup.findNext(searchStartIndex, (Filter<Integer>)RadioButtonGroup.this.firstCharacterFilter, true);
                } else if (shiftPressed) {
                    result = radioButtonGroup.findPrevious(searchStartIndex, (Filter<Integer>)RadioButtonGroup.this.firstCharacterFilter, true);
                }
                if (result != -1 && result != searchStartIndex) {
                    radioButtonGroup.setSelection(result);
                    handled = true;
                }
            }
            return handled;
        }
    };
    private final ButtonGroupListener buttonGroupListener = new ButtonGroupListener.Adapter(){

        @Override
        public void buttonAdded(ButtonGroup buttonGroup, Button button) {
            button.getComponentKeyListeners().add((Object)RadioButtonGroup.this.componentKeyListener);
        }

        @Override
        public void buttonRemoved(ButtonGroup buttonGroup, Button button) {
            button.getComponentKeyListeners().remove((Object)RadioButtonGroup.this.componentKeyListener);
        }
    };
    private final Filter<Integer> defaultFilter = new Filter<Integer>(){

        public boolean include(Integer index) {
            Button button = (Button)RadioButtonGroup.this.buttonOrder.get(index.intValue());
            boolean focusable = button.isFocusable();
            return focusable;
        }
    };
    private final FirstCharacterFilter firstCharacterFilter = new FirstCharacterFilter();
    private final List<Button> buttonOrder = new ArrayList();
    private boolean circular = false;
    private boolean intraGroupFocusTransferEnabled = false;
    private static final int NOT_FOUND_INDEX = -1;
    private static final int NO_SELECTION_INDEX = -1;

    public RadioButtonGroup() {
        this.getButtonGroupListeners().add((Object)this.buttonGroupListener);
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) {
        this.circular = circular;
    }

    public boolean isIntraGroupFocusTransferEnabled() {
        return this.intraGroupFocusTransferEnabled;
    }

    public void setIntraGroupFocusTransferEnabled(boolean intraGroupFocusTransferEnabled) {
        this.intraGroupFocusTransferEnabled = intraGroupFocusTransferEnabled;
    }

    @Override
    public boolean add(Button button) {
        if (button == null) {
            throw new IllegalArgumentException("Button cannot be null");
        }
        boolean result = super.add(button);
        if (result) {
            this.buttonOrder.add((Object)button);
        }
        return result;
    }

    public Button get(int index) {
        return (Button)this.buttonOrder.get(index);
    }

    public int getLength() {
        return this.buttonOrder.getLength();
    }

    public int indexOf(Button button) {
        return this.buttonOrder.indexOf((Object)button);
    }

    public void insert(Button button, int index) {
        if (button == null) {
            throw new IllegalArgumentException("Button cannot be null");
        }
        boolean result = super.add(button);
        if (result) {
            this.buttonOrder.insert((Object)button, index);
        }
    }

    @Override
    public boolean remove(Button button) {
        boolean result = false;
        if (button != null && (result = super.remove(button))) {
            this.buttonOrder.remove((Object)button);
        }
        return result;
    }

    public Sequence<Button> remove(int index, int count) {
        int countMutable = count;
        ArrayList removed = new ArrayList();
        while (countMutable-- > 0) {
            Button button = this.get(index);
            boolean result = this.remove(button);
            if (!result) continue;
            removed.add((Object)button);
        }
        return removed;
    }

    @Override
    public Iterator<Button> iterator() {
        return new ImmutableIterator(this.buttonOrder.iterator());
    }

    @Override
    public void setSelection(Button button) {
        super.setSelection(button);
        if (button != null) {
            button.requestFocus();
        }
    }

    public void setSelection(int index) {
        if (index != -1) {
            this.setSelection((Button)this.buttonOrder.get(index));
        }
    }

    public void selectFirstButton() {
        this.setSelection(this.findNext(-1));
    }

    public void selectLastButton() {
        this.setSelection(this.findPrevious(this.buttonOrder.getLength()));
    }

    public void selectNextButton(Button button) {
        Button buttonWithDefault = button;
        if (buttonWithDefault == null) {
            int index;
            Component focusedComponent;
            buttonWithDefault = this.getSelection();
            if (buttonWithDefault == null && (focusedComponent = Component.getFocusedComponent()) instanceof Button && (index = this.indexOf((Button)focusedComponent)) != -1) {
                buttonWithDefault = this.get(index);
            }
            if (buttonWithDefault != null) {
                this.selectNextButton(buttonWithDefault);
            } else {
                this.selectFirstButton();
            }
        } else {
            int index = this.indexOf(buttonWithDefault);
            if (index == -1) {
                throw new IllegalArgumentException("Button does not belong to this RadioButtonGroup.");
            }
            if ((index = this.findNext(index)) != -1) {
                this.setSelection(index);
            }
        }
    }

    public void selectPreviousButton(Button button) {
        Button buttonWithDefault = button;
        if (buttonWithDefault == null) {
            int index;
            Component focusedComponent;
            buttonWithDefault = this.getSelection();
            if (buttonWithDefault == null && (focusedComponent = Component.getFocusedComponent()) instanceof Button && (index = this.indexOf((Button)focusedComponent)) != -1) {
                buttonWithDefault = this.get(index);
            }
            if (buttonWithDefault != null) {
                this.selectPreviousButton(buttonWithDefault);
            } else {
                this.selectLastButton();
            }
        } else {
            int index = this.indexOf(buttonWithDefault);
            if (index == -1) {
                throw new IllegalArgumentException("Button does not belong to this RadioButtonGroup.");
            }
            if ((index = this.findPrevious(index)) != -1) {
                this.setSelection(index);
            }
        }
    }

    private int findNext(int index, Filter<Integer> filter, boolean circularArgument) {
        Filter<Integer> filterWithDefault = filter == null ? this.defaultFilter : filter;
        int result = -1;
        int length = this.buttonOrder.getLength();
        if (length > 0) {
            int i;
            for (i = index + 1; i < length; ++i) {
                if (!filterWithDefault.include((Object)i)) continue;
                result = i;
                break;
            }
            if (circularArgument && result == -1) {
                for (i = 0; i <= index; ++i) {
                    if (!filterWithDefault.include((Object)i)) continue;
                    result = i;
                    break;
                }
            }
        }
        return result;
    }

    private int findNext(int index) {
        return this.findNext(index, this.defaultFilter, this.circular);
    }

    private int findPrevious(int index, Filter<Integer> filter, boolean circularArgument) {
        Filter<Integer> filterWithDefault = filter == null ? this.defaultFilter : filter;
        int result = -1;
        int length = this.buttonOrder.getLength();
        if (length > 0) {
            int i;
            for (i = index - 1; i >= 0; --i) {
                if (!filterWithDefault.include((Object)i)) continue;
                result = i;
                break;
            }
            if (circularArgument && result == -1) {
                for (i = length - 1; i >= index; --i) {
                    if (!filterWithDefault.include((Object)i)) continue;
                    result = i;
                    break;
                }
            }
        }
        return result;
    }

    private int findPrevious(int index) {
        return this.findPrevious(index, this.defaultFilter, this.circular);
    }

    private class FirstCharacterFilter
    implements Filter<Integer> {
        private char target = '\u0000';

        private FirstCharacterFilter() {
        }

        public void setTarget(char target) {
            this.target = Character.toUpperCase(target);
        }

        public boolean include(Integer index) {
            char first;
            Button button;
            String rendered;
            boolean include = RadioButtonGroup.this.defaultFilter.include((Object)index);
            if (include && (rendered = (button = (Button)RadioButtonGroup.this.buttonOrder.get(index.intValue())).getDataRenderer().toString(button.getButtonData())) != null && rendered.length() > 0 && (first = Character.toUpperCase(rendered.charAt(0))) != this.target) {
                include = false;
            }
            return include;
        }
    }
}

