/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MeterListener;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.WTKListenerList;

public class Meter
extends Component {
    private double percentage = 0.0;
    private String text = null;
    private Orientation orientation = null;
    private MeterListenerList meterListeners = new MeterListenerList();

    public Meter() {
        this(Orientation.HORIZONTAL);
    }

    public Meter(Orientation orientation) {
        this.orientation = orientation;
        this.installSkin(Meter.class);
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage must be a number between 0 and 1");
        }
        double previousPercentage = this.percentage;
        if (previousPercentage != percentage) {
            this.percentage = percentage;
            this.meterListeners.percentageChanged(this, previousPercentage);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String previousText = this.text;
        this.text = text;
        this.meterListeners.textChanged(this, previousText);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.meterListeners.orientationChanged(this);
        }
    }

    public ListenerList<MeterListener> getMeterListeners() {
        return this.meterListeners;
    }

    private static class MeterListenerList
    extends WTKListenerList<MeterListener>
    implements MeterListener {
        private MeterListenerList() {
        }

        @Override
        public void orientationChanged(Meter meter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MeterListener listener = (MeterListener)i$.next();
                listener.orientationChanged(meter);
            }
        }

        @Override
        public void percentageChanged(Meter meter, double oldPercentage) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MeterListener listener = (MeterListener)i$.next();
                listener.percentageChanged(meter, oldPercentage);
            }
        }

        @Override
        public void textChanged(Meter meter, String oldText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MeterListener listener = (MeterListener)i$.next();
                listener.textChanged(meter, oldText);
            }
        }
    }
}

