/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FormAttributeListener;
import org.apache.pivot.wtk.FormListener;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.WTKListenerList;

@DefaultProperty(value="sections")
public class Form
extends Container {
    private ArrayList<Section> sections = new ArrayList();
    private SectionSequence sectionSequence = new SectionSequence();
    private FormListenerList formListeners = new FormListenerList();
    private FormAttributeListenerList formAttributeListeners = new FormAttributeListenerList();

    public Form() {
        this.installSkin(Form.class);
    }

    public SectionSequence getSections() {
        return this.sectionSequence;
    }

    public void clearFlags() {
        for (Section section : this.sections) {
            for (Component field : section) {
                Form.setFlag(field, (Flag)null);
            }
        }
    }

    public int getFlaggedFieldCount(MessageType messageType) {
        int count = 0;
        for (Section section : this.sections) {
            for (Component field : section) {
                Flag flag = Form.getFlag(field);
                if (flag == null || messageType != null && flag.getMessageType() != messageType) continue;
                ++count;
            }
        }
        return count;
    }

    public void scrollFirstFlagToVisible(MessageType messageType) {
        Flag flag = null;
        for (Section section : this.sections) {
            for (Component field : section) {
                flag = Form.getFlag(field);
                if (flag == null || messageType != null && flag.getMessageType() != messageType) continue;
                field.scrollAreaToVisible(0, 0, field.getWidth(), field.getHeight());
                break;
            }
            if (flag == null) continue;
            break;
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            for (Section section : this.sections) {
                if (section.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(index, count);
    }

    public ListenerList<FormListener> getFormListeners() {
        return this.formListeners;
    }

    public ListenerList<FormAttributeListener> getFormAttributeListeners() {
        return this.formAttributeListeners;
    }

    public static Section getSection(Component component) {
        return (Section)component.getAttribute(Attribute.SECTION);
    }

    public static Section getEnclosingSection(Component component) {
        Section section = (Section)component.getAttribute(Attribute.SECTION);
        if (section == null) {
            for (Container parent = component.getParent(); parent != null && (section = (Section)parent.getAttribute(Attribute.SECTION)) == null; parent = parent.getParent()) {
            }
        }
        return section;
    }

    public static String getLabel(Component component) {
        return (String)component.getAttribute(Attribute.LABEL);
    }

    public static void setLabel(Component component, String label) {
        Container parent;
        String previousLabel = (String)component.setAttribute(Attribute.LABEL, label);
        if (previousLabel != label && (parent = component.getParent()) instanceof Form) {
            Form form = (Form)parent;
            form.formAttributeListeners.labelChanged(form, component, previousLabel);
        }
    }

    public static boolean isRequired(Component component) {
        Boolean value = (Boolean)component.getAttribute(Attribute.REQUIRED);
        return value == null ? false : value;
    }

    public static void setRequired(Component component, boolean required) {
        Container parent;
        boolean previousRequired;
        Boolean previousValue = (Boolean)component.setAttribute(Attribute.REQUIRED, required);
        boolean bl = previousRequired = previousValue == null ? false : previousValue;
        if (previousRequired != required && (parent = component.getParent()) instanceof Form) {
            Form form = (Form)parent;
            form.formAttributeListeners.requiredChanged(form, component);
        }
    }

    public static Flag getFlag(Component component) {
        return (Flag)component.getAttribute(Attribute.FLAG);
    }

    public static void setFlag(Component component, Flag flag) {
        Container parent;
        Flag previousFlag = (Flag)component.setAttribute(Attribute.FLAG, flag);
        if (previousFlag != flag && (parent = component.getParent()) instanceof Form) {
            Form form = (Form)parent;
            form.formAttributeListeners.flagChanged(form, component, previousFlag);
        }
    }

    public static final void setFlag(Component component, String flag) {
        if (flag == null) {
            throw new IllegalArgumentException("flag is null.");
        }
        Form.setFlag(component, Flag.decode(flag));
    }

    public static final void clearFlag(Component component) {
        Form.setFlag(component, (Flag)null);
    }

    private static class FormAttributeListenerList
    extends WTKListenerList<FormAttributeListener>
    implements FormAttributeListener {
        private FormAttributeListenerList() {
        }

        @Override
        public void labelChanged(Form form, Component component, String previousLabel) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormAttributeListener listener = (FormAttributeListener)i$.next();
                listener.labelChanged(form, component, previousLabel);
            }
        }

        @Override
        public void requiredChanged(Form form, Component field) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormAttributeListener listener = (FormAttributeListener)i$.next();
                listener.requiredChanged(form, field);
            }
        }

        @Override
        public void flagChanged(Form form, Component component, Flag previousFlag) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormAttributeListener listener = (FormAttributeListener)i$.next();
                listener.flagChanged(form, component, previousFlag);
            }
        }
    }

    private static class FormListenerList
    extends WTKListenerList<FormListener>
    implements FormListener {
        private FormListenerList() {
        }

        @Override
        public void sectionInserted(Form form, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormListener listener = (FormListener)i$.next();
                listener.sectionInserted(form, index);
            }
        }

        @Override
        public void sectionsRemoved(Form form, int index, Sequence<Section> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormListener listener = (FormListener)i$.next();
                listener.sectionsRemoved(form, index, removed);
            }
        }

        @Override
        public void sectionHeadingChanged(Section section) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormListener listener = (FormListener)i$.next();
                listener.sectionHeadingChanged(section);
            }
        }

        @Override
        public void fieldInserted(Section section, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormListener listener = (FormListener)i$.next();
                listener.fieldInserted(section, index);
            }
        }

        @Override
        public void fieldsRemoved(Section section, int index, Sequence<Component> fields) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FormListener listener = (FormListener)i$.next();
                listener.fieldsRemoved(section, index, fields);
            }
        }
    }

    private static enum Attribute {
        SECTION,
        LABEL,
        REQUIRED,
        FLAG;

    }

    public static class Flag {
        private MessageType messageType = null;
        private String message = null;
        public static final String MESSAGE_TYPE_KEY = "messageType";
        public static final String MESSAGE_KEY = "message";

        public Flag() {
            this(MessageType.ERROR, null);
        }

        public Flag(MessageType messageType) {
            this(messageType, null);
        }

        public Flag(MessageType messageType, String message) {
            if (messageType == null) {
                throw new IllegalArgumentException("messageType is null.");
            }
            this.messageType = messageType;
            this.message = message;
        }

        public MessageType getMessageType() {
            return this.messageType;
        }

        public void setMessageType(MessageType messageType) {
            if (messageType == null) {
                throw new IllegalArgumentException();
            }
            this.messageType = messageType;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public static Flag decode(String flag) {
            Map map;
            try {
                map = JSONSerializer.parseMap((String)flag);
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
            String messageType = (String)map.get((Object)MESSAGE_TYPE_KEY);
            if (messageType == null) {
                throw new IllegalArgumentException("messageType is required.");
            }
            Flag value = new Flag(MessageType.valueOf(messageType.toUpperCase(Locale.ENGLISH)), (String)map.get((Object)MESSAGE_KEY));
            return value;
        }
    }

    public final class SectionSequence
    implements Sequence<Section>,
    Iterable<Section> {
        private SectionSequence() {
        }

        public int add(Section section) {
            int index = this.getLength();
            this.insert(section, index);
            return index;
        }

        public void insert(Section section, int index) {
            if (section.form != null) {
                throw new IllegalArgumentException("section already has a form.");
            }
            Form.this.sections.insert((Object)section, index);
            section.form = Form.this;
            int n = section.getLength();
            for (int i = 0; i < n; ++i) {
                Form.this.add(section.get(i));
            }
            Form.this.formListeners.sectionInserted(Form.this, index);
        }

        public Section update(int index, Section section) {
            throw new UnsupportedOperationException();
        }

        public int remove(Section section) {
            int index = Form.this.sections.indexOf((Object)section);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Section> remove(int index, int count) {
            Sequence removed = Form.this.sections.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Section section = (Section)removed.get(i);
                section.form = null;
                for (Component field : section) {
                    Form.this.remove(field);
                }
            }
            Form.this.formListeners.sectionsRemoved(Form.this, index, (Sequence<Section>)removed);
            return removed;
        }

        public Section get(int index) {
            return (Section)Form.this.sections.get(index);
        }

        public int indexOf(Section item) {
            return Form.this.sections.indexOf((Object)item);
        }

        public int getLength() {
            return Form.this.sections.getLength();
        }

        @Override
        public Iterator<Section> iterator() {
            return new ImmutableIterator((Iterator)Form.this.sections.iterator());
        }
    }

    public static class Section
    implements Sequence<Component>,
    Iterable<Component> {
        private Form form = null;
        private String heading = null;
        private ArrayList<Component> fields = new ArrayList();

        public Form getForm() {
            return this.form;
        }

        public String getHeading() {
            return this.heading;
        }

        public void setHeading(String heading) {
            String previousHeading = this.heading;
            if (previousHeading != heading) {
                this.heading = heading;
                if (this.form != null) {
                    this.form.formListeners.sectionHeadingChanged(this);
                }
            }
        }

        public int add(Component field) {
            int index = this.getLength();
            this.insert(field, index);
            return index;
        }

        public void insert(Component field, int index) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            if (field.getParent() != null) {
                throw new IllegalArgumentException("Field already has a parent.");
            }
            this.fields.insert((Object)field, index);
            field.setAttribute(Attribute.SECTION, this);
            if (this.form != null) {
                this.form.add(field);
                this.form.formListeners.fieldInserted(this, index);
            }
        }

        public Component update(int index, Component field) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component field) {
            int index = this.fields.indexOf((Object)field);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Component> remove(int index, int count) {
            Sequence removed = this.fields.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Component field = (Component)removed.get(i);
                field.setAttribute(Attribute.SECTION, null);
                if (this.form == null) continue;
                this.form.remove(field);
            }
            if (this.form != null) {
                this.form.formListeners.fieldsRemoved(this, index, (Sequence<Component>)removed);
            }
            return removed;
        }

        public Component get(int index) {
            return (Component)this.fields.get(index);
        }

        public int indexOf(Component field) {
            return this.fields.indexOf((Object)field);
        }

        public int getLength() {
            return this.fields.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.fields.iterator());
        }
    }
}

