/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BorderListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.WTKListenerList;

@DefaultProperty(value="content")
public class Border
extends Container {
    private String title = null;
    private Component content = null;
    private BorderListenerList borderListeners = new BorderListenerList();

    public Border() {
        this(null);
    }

    public Border(Component content) {
        this.installSkin(Border.class);
        this.setContent(content);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String previousTitle = this.title;
        if (previousTitle != title) {
            this.title = title;
            this.borderListeners.titleChanged(this, previousTitle);
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Component previousContent = this.content;
        if (content != previousContent) {
            this.content = null;
            if (previousContent != null) {
                this.remove(previousContent);
            }
            if (content != null) {
                this.add(content);
            }
            this.content = content;
            this.borderListeners.contentChanged(this, previousContent);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<BorderListener> getBorderListeners() {
        return this.borderListeners;
    }

    private static class BorderListenerList
    extends WTKListenerList<BorderListener>
    implements BorderListener {
        private BorderListenerList() {
        }

        @Override
        public void titleChanged(Border border, String previousTitle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                BorderListener listener = (BorderListener)i$.next();
                listener.titleChanged(border, previousTitle);
            }
        }

        @Override
        public void contentChanged(Border border, Component previousContent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                BorderListener listener = (BorderListener)i$.next();
                listener.contentChanged(border, previousContent);
            }
        }
    }
}

