/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.pinot.core.transport.ListenerConfig;
import org.apache.pinot.core.util.ListenerConfigUtil;
import org.apache.pinot.server.api.access.AccessControlFactory;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApiApplication
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminApiApplication.class);
    public static final String PINOT_CONFIGURATION = "pinotConfiguration";
    public static final String RESOURCE_PACKAGE = "org.apache.pinot.server.api.resources";
    private final ServerInstance _serverInstance;
    private final AccessControlFactory _accessControlFactory;
    private boolean _started = false;
    private HttpServer _httpServer;

    public AdminApiApplication(ServerInstance instance, final AccessControlFactory accessControlFactory, PinotConfiguration serverConf) {
        this._serverInstance = instance;
        this._accessControlFactory = accessControlFactory;
        this.packages(new String[]{RESOURCE_PACKAGE});
        this.property(PINOT_CONFIGURATION, serverConf);
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(AdminApiApplication.this._serverInstance).to(ServerInstance.class);
                this.bind(accessControlFactory).to(AccessControlFactory.class);
            }
        });
        this.register(JacksonFeature.class);
        this.registerClasses(new Class[]{ApiListingResource.class});
        this.registerClasses(new Class[]{SwaggerSerializers.class});
        this.register(new ContainerResponseFilter(){

            public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
                containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(List<ListenerConfig> listenerConfigs) {
        this._httpServer = ListenerConfigUtil.buildHttpServer((ResourceConfig)this, listenerConfigs);
        try {
            this._httpServer.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start http server", e);
        }
        PinotConfiguration pinotConfiguration = (PinotConfiguration)this.getProperties().get(PINOT_CONFIGURATION);
        if (pinotConfiguration.getProperty("pinot.server.swagger.enabled", true)) {
            LOGGER.info("Starting swagger for the Pinot server.");
            Object object = PinotReflectionUtils.getReflectionLock();
            synchronized (object) {
                this.setupSwagger(this._httpServer);
            }
        }
        this._started = true;
        return true;
    }

    private void setupSwagger(HttpServer httpServer) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Pinot Server API");
        beanConfig.setDescription("APIs for accessing Pinot server information");
        beanConfig.setContact("https://github.com/apache/incubator-pinot");
        beanConfig.setVersion("1.0");
        beanConfig.setSchemes(new String[]{"http", "https"});
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage(RESOURCE_PACKAGE);
        beanConfig.setScan(true);
        try {
            beanConfig.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get localhost name");
        }
        CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(AdminApiApplication.class.getClassLoader(), new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/help/"});
        URL swaggerDistLocation = AdminApiApplication.class.getClassLoader().getResource("META-INF/resources/webjars/swagger-ui/3.23.11/");
        CLStaticHttpHandler swaggerDist = new CLStaticHttpHandler((ClassLoader)new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }

    public void stop() {
        if (!this._started) {
            return;
        }
        this._httpServer.shutdownNow();
    }
}

