/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.server.starter.ServerInstance;

public class ServerResourceUtils {
    private ServerResourceUtils() {
    }

    public static TableDataManager checkGetTableDataManager(ServerInstance serverInstance, String tableName) {
        InstanceDataManager dataManager = ServerResourceUtils.checkGetInstanceDataManager(serverInstance);
        TableDataManager tableDataManager = dataManager.getTableDataManager(tableName);
        if (tableDataManager == null) {
            throw new WebApplicationException("Table " + tableName + " does not exist", Response.Status.NOT_FOUND);
        }
        return tableDataManager;
    }

    public static InstanceDataManager checkGetInstanceDataManager(ServerInstance serverInstance) {
        if (serverInstance == null) {
            throw new WebApplicationException("Server initialization error. Missing server instance");
        }
        InstanceDataManager instanceDataManager = serverInstance.getInstanceDataManager();
        if (instanceDataManager == null) {
            throw new WebApplicationException("Server initialization error. Missing data manager", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return instanceDataManager;
    }
}

