/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.restlet.resources.ResourceUtils;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

@Api(value="debug", description="Debug information", tags={"Debug"})
@Path(value="debug")
public class MmapDebugResource {
    @Inject
    private ServerInstance _serverInstance;

    @GET
    @Path(value="memory/offheap")
    @ApiOperation(value="View current off-heap allocations", notes="Lists all off-heap allocations and their associated sizes")
    @ApiResponses(value={@ApiResponse(code=200, message="Success")})
    @Produces(value={"application/json"})
    public List<String> getOffHeapSizes() {
        return PinotDataBuffer.getBufferInfo();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/memory/offheap/table/{tableName}")
    @ApiOperation(value="Show off heap memory consumed by latest mutable segment", notes="Returns off heap memory consumed by latest consuming segment of realtime table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    public String getTableSize(@ApiParam(value="Table Name with type", required=true) @PathParam(value="tableName") String tableName) throws WebApplicationException {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME) {
            throw new WebApplicationException("This api cannot be used with non real-time table: " + tableName, Response.Status.BAD_REQUEST);
        }
        InstanceDataManager instanceDataManager = this._serverInstance.getInstanceDataManager();
        if (instanceDataManager == null) {
            throw new WebApplicationException("Invalid server initialization", Response.Status.INTERNAL_SERVER_ERROR);
        }
        RealtimeTableDataManager realtimeTableDataManager = (RealtimeTableDataManager)instanceDataManager.getTableDataManager(tableName);
        if (realtimeTableDataManager == null) {
            throw new WebApplicationException("Table: " + tableName + " is not found", Response.Status.NOT_FOUND);
        }
        long memoryConsumed = realtimeTableDataManager.getStatsHistory().getLatestSegmentMemoryConsumed();
        return ResourceUtils.convertToJsonString(Collections.singletonMap("offheapMemoryConsumed", memoryConsumed));
    }
}

