/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.utils.ServiceStatus;

@Api(tags={"Health"})
@Path(value="/")
public class HealthCheckResource {
    @GET
    @Path(value="/health")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Checking server health")
    @ApiResponses(value={@ApiResponse(code=200, message="Server is healthy"), @ApiResponse(code=503, message="Server is not healthy")})
    public String checkHealth() {
        ServiceStatus.Status status = ServiceStatus.getServiceStatus();
        if (status == ServiceStatus.Status.GOOD) {
            return "OK";
        }
        throw new WebApplicationException(String.format("Pinot server status is %s", status), Response.Status.SERVICE_UNAVAILABLE);
    }
}

