/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.validation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.metrics.ValidationMetrics;
import org.apache.pinot.common.utils.HLCSegmentName;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.controller.helix.core.realtime.PinotLLCRealtimeSegmentManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeSegmentValidationManager
extends ControllerPeriodicTask<Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeSegmentValidationManager.class);
    private final PinotLLCRealtimeSegmentManager _llcRealtimeSegmentManager;
    private final ValidationMetrics _validationMetrics;
    private final int _segmentLevelValidationIntervalInSeconds;
    private long _lastSegmentLevelValidationRunTimeMs = 0L;
    public static final String RECREATE_DELETED_CONSUMING_SEGMENT_KEY = "recreateDeletedConsumingSegment";
    public static final String OFFSET_CRITERIA = "offsetCriteria";

    public RealtimeSegmentValidationManager(ControllerConf config, PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, PinotLLCRealtimeSegmentManager llcRealtimeSegmentManager, ValidationMetrics validationMetrics, ControllerMetrics controllerMetrics) {
        super("RealtimeSegmentValidationManager", config.getRealtimeSegmentValidationFrequencyInSeconds(), config.getRealtimeSegmentValidationManagerInitialDelaySeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._llcRealtimeSegmentManager = llcRealtimeSegmentManager;
        this._validationMetrics = validationMetrics;
        this._segmentLevelValidationIntervalInSeconds = config.getSegmentLevelValidationIntervalInSeconds();
        Preconditions.checkState((this._segmentLevelValidationIntervalInSeconds > 0 ? 1 : 0) != 0);
    }

    @Override
    protected Context preprocess(Properties periodicTaskProperties) {
        Context context = new Context();
        long currentTimeMs = System.currentTimeMillis();
        if (TimeUnit.MILLISECONDS.toSeconds(currentTimeMs - this._lastSegmentLevelValidationRunTimeMs) >= (long)this._segmentLevelValidationIntervalInSeconds) {
            LOGGER.info("Run segment-level validation");
            context._runSegmentLevelValidation = true;
            this._lastSegmentLevelValidationRunTimeMs = currentTimeMs;
        }
        context._recreateDeletedConsumingSegment = Boolean.parseBoolean(periodicTaskProperties.getProperty(RECREATE_DELETED_CONSUMING_SEGMENT_KEY));
        String offsetCriteriaStr = periodicTaskProperties.getProperty(OFFSET_CRITERIA);
        if (offsetCriteriaStr != null) {
            context._offsetCriteria = new OffsetCriteria.OffsetCriteriaBuilder().withOffsetString(offsetCriteriaStr);
        }
        return context;
    }

    @Override
    protected void processTable(String tableNameWithType, Context context) {
        if (!TableNameBuilder.isRealtimeTableResource((String)tableNameWithType)) {
            return;
        }
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        if (tableConfig == null) {
            LOGGER.warn("Failed to find table config for table: {}, skipping validation", (Object)tableNameWithType);
            return;
        }
        PartitionLevelStreamConfig streamConfig = new PartitionLevelStreamConfig(tableConfig.getTableName(), IngestionConfigUtils.getStreamConfigMap((TableConfig)tableConfig));
        if (context._runSegmentLevelValidation) {
            this.runSegmentLevelValidation(tableConfig, streamConfig);
        }
        if (streamConfig.hasLowLevelConsumerType()) {
            this._llcRealtimeSegmentManager.ensureAllPartitionsConsuming(tableConfig, streamConfig, context._recreateDeletedConsumingSegment, context._offsetCriteria);
        }
    }

    private void runSegmentLevelValidation(TableConfig tableConfig, PartitionLevelStreamConfig streamConfig) {
        String realtimeTableName = tableConfig.getTableName();
        List<SegmentZKMetadata> segmentsZKMetadata = this._pinotHelixResourceManager.getSegmentsZKMetadata(realtimeTableName);
        boolean countHLCSegments = streamConfig.hasHighLevelConsumerType();
        this._validationMetrics.updateTotalDocumentCountGauge(realtimeTableName, RealtimeSegmentValidationManager.computeTotalDocumentCount(segmentsZKMetadata, countHLCSegments));
        if (streamConfig.hasLowLevelConsumerType() && this._llcRealtimeSegmentManager.isDeepStoreLLCSegmentUploadRetryEnabled()) {
            this._llcRealtimeSegmentManager.uploadToDeepStoreIfMissing(tableConfig, segmentsZKMetadata);
        }
    }

    @Override
    protected void nonLeaderCleanup(List<String> tableNamesWithType) {
        for (String tableNameWithType : tableNamesWithType) {
            if (!TableNameBuilder.isRealtimeTableResource((String)tableNameWithType)) continue;
            this._validationMetrics.cleanupTotalDocumentCountGauge(tableNameWithType);
        }
    }

    @VisibleForTesting
    static long computeTotalDocumentCount(List<SegmentZKMetadata> segmentsZKMetadata, boolean countHLCSegments) {
        long numTotalDocs = 0L;
        if (countHLCSegments) {
            String groupId = null;
            for (SegmentZKMetadata segmentZKMetadata : segmentsZKMetadata) {
                String segmentName = segmentZKMetadata.getSegmentName();
                if (!SegmentName.isHighLevelConsumerSegmentName((String)segmentName)) continue;
                HLCSegmentName hlcSegmentName = new HLCSegmentName(segmentName);
                String segmentGroupId = hlcSegmentName.getGroupId();
                if (groupId == null) {
                    groupId = segmentGroupId;
                    numTotalDocs = segmentZKMetadata.getTotalDocs();
                    continue;
                }
                if (!groupId.equals(segmentGroupId)) continue;
                numTotalDocs += segmentZKMetadata.getTotalDocs();
            }
        } else {
            for (SegmentZKMetadata segmentZKMetadata : segmentsZKMetadata) {
                String segmentName = segmentZKMetadata.getSegmentName();
                if (SegmentName.isHighLevelConsumerSegmentName((String)segmentName)) continue;
                numTotalDocs += segmentZKMetadata.getTotalDocs();
            }
        }
        return numTotalDocs;
    }

    public void cleanUpTask() {
        LOGGER.info("Unregister all the validation metrics.");
        this._validationMetrics.unregisterAllMetrics();
    }

    @VisibleForTesting
    public ValidationMetrics getValidationMetrics() {
        return this._validationMetrics;
    }

    public static final class Context {
        private boolean _runSegmentLevelValidation;
        private boolean _recreateDeletedConsumingSegment;
        private OffsetCriteria _offsetCriteria;
    }
}

