/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.restlet.resources.TableMetadataInfo;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.ServerSegmentMetadataReader;
import org.apache.pinot.spi.utils.JsonUtils;

public class TableMetadataReader {
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;
    private final PinotHelixResourceManager _pinotHelixResourceManager;

    public TableMetadataReader(Executor executor, HttpClientConnectionManager connectionManager, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._pinotHelixResourceManager = helixResourceManager;
    }

    public JsonNode getSegmentsMetadata(String tableNameWithType, List<String> columns, int timeoutMs) throws InvalidConfigException, IOException {
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        BiMap<String, String> endpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._executor, this._connectionManager);
        List<String> segmentsMetadata = serverSegmentMetadataReader.getSegmentMetadataFromServer(tableNameWithType, serverToSegments, endpoints, columns, timeoutMs);
        HashMap<String, JsonNode> response = new HashMap<String, JsonNode>();
        for (String segmentMetadata : segmentsMetadata) {
            JsonNode responseJson = JsonUtils.stringToJsonNode((String)segmentMetadata);
            response.put(responseJson.get("segmentName").asText(), responseJson);
        }
        return JsonUtils.objectToJsonNode(response);
    }

    public JsonNode getSegmentMetadata(String tableNameWithType, String segmentName, List<String> columns, int timeoutMs) throws InvalidConfigException, IOException {
        Set<String> servers = this._pinotHelixResourceManager.getServers(tableNameWithType, segmentName);
        Map<String, List<String>> serverToSegments = servers.stream().collect(Collectors.toMap(s -> s, s -> Collections.singletonList(segmentName)));
        BiMap<String, String> endpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(servers);
        ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._executor, this._connectionManager);
        List<String> segmentsMetadata = serverSegmentMetadataReader.getSegmentMetadataFromServer(tableNameWithType, serverToSegments, endpoints, columns, timeoutMs);
        for (String segmentMetadata : segmentsMetadata) {
            JsonNode responseJson = JsonUtils.stringToJsonNode((String)segmentMetadata);
            String segmentNameJson = responseJson.get("segmentName").asText();
            if (!segmentNameJson.equals(segmentName)) continue;
            return responseJson;
        }
        return JsonUtils.objectToJsonNode(new HashMap());
    }

    public JsonNode getAggregateTableMetadata(String tableNameWithType, List<String> columns, int numReplica, int timeoutMs) throws InvalidConfigException, IOException {
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        BiMap<String, String> endpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._executor, this._connectionManager);
        TableMetadataInfo aggregateTableMetadataInfo = serverSegmentMetadataReader.getAggregatedTableMetadataFromServer(tableNameWithType, endpoints, columns, numReplica, timeoutMs);
        return JsonUtils.objectToJsonNode((Object)aggregateTableMetadataInfo);
    }
}

