/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Random;
import org.apache.pinot.controller.recommender.data.generator.Generator;

public class JsonGenerator
implements Generator {
    static final int DEFAULT_JSON_ELEMENT_LENGTH = 5;
    private final int _jsonStringLength;
    private final Random _random;

    public JsonGenerator(Integer jsonSize) {
        this._jsonStringLength = jsonSize == null || jsonSize <= 0 ? 0 : jsonSize;
        this._random = new Random(System.currentTimeMillis());
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        if (this._jsonStringLength == 0 || this._jsonStringLength / 5 == 0) {
            return "{}";
        }
        StringBuffer jsonBuffer = new StringBuffer();
        int elementCount = this._jsonStringLength / 5;
        jsonBuffer.append("{");
        for (int i = 0; i < elementCount; ++i) {
            if (jsonBuffer.length() > 1) {
                jsonBuffer.append("\\,");
            }
            String item = "\"" + (char)(97 + this._random.nextInt(26)) + "\":" + this._random.nextInt(10);
            jsonBuffer.append(item);
        }
        return jsonBuffer.append("}").toString();
    }
}

