/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance.tenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TenantRebalanceProgressStats {
    private Map<String, String> _tableStatusMap;
    private final Map<String, String> _tableRebalanceJobIdMap = new HashMap<String, String>();
    private int _totalTables;
    private int _remainingTables;
    private long _startTimeMs;
    private long _timeToFinishInSeconds;
    private String _completionStatusMsg;

    public TenantRebalanceProgressStats() {
    }

    public TenantRebalanceProgressStats(Set<String> tables) {
        this._tableStatusMap = tables.stream().collect(Collectors.toMap(Function.identity(), k -> TableStatus.UNPROCESSED.name()));
        this._remainingTables = this._totalTables = tables.size();
    }

    public Map<String, String> getTableStatusMap() {
        return this._tableStatusMap;
    }

    public void setTableStatusMap(Map<String, String> tableStatusMap) {
        this._tableStatusMap = tableStatusMap;
    }

    public int getTotalTables() {
        return this._totalTables;
    }

    public void setTotalTables(int totalTables) {
        this._totalTables = totalTables;
    }

    public int getRemainingTables() {
        return this._remainingTables;
    }

    public void setRemainingTables(int remainingTables) {
        this._remainingTables = remainingTables;
    }

    public long getStartTimeMs() {
        return this._startTimeMs;
    }

    public void setStartTimeMs(long startTimeMs) {
        this._startTimeMs = startTimeMs;
    }

    public long getTimeToFinishInSeconds() {
        return this._timeToFinishInSeconds;
    }

    public void setTimeToFinishInSeconds(long timeToFinishInSeconds) {
        this._timeToFinishInSeconds = timeToFinishInSeconds;
    }

    public String getCompletionStatusMsg() {
        return this._completionStatusMsg;
    }

    public void setCompletionStatusMsg(String completionStatusMsg) {
        this._completionStatusMsg = completionStatusMsg;
    }

    public void updateTableStatus(String tableName, String status) {
        this._tableStatusMap.put(tableName, status);
    }

    public void putTableRebalanceJobId(String tableName, String jobId) {
        this._tableRebalanceJobIdMap.put(tableName, jobId);
    }

    public Map<String, String> getTableRebalanceJobIdMap() {
        return this._tableRebalanceJobIdMap;
    }

    public static enum TableStatus {
        UNPROCESSED,
        PROCESSING,
        PROCESSED;

    }
}

