/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTypeMetricsUpdater
implements IZkDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTypeMetricsUpdater.class);
    private final String _taskType;
    private final PinotTaskManager _pinotTaskManager;

    public TaskTypeMetricsUpdater(String taskType, PinotTaskManager pinotTaskManager) {
        this._taskType = taskType;
        this._pinotTaskManager = pinotTaskManager;
    }

    public void handleDataChange(String dataPath, Object data) {
        this.updateMetrics();
    }

    public void handleDataDeleted(String dataPath) {
        this.updateMetrics();
    }

    private void updateMetrics() {
        try {
            this._pinotTaskManager.reportMetrics(this._taskType);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update metrics for task type {}", (Object)this._taskType, (Object)e);
            throw e;
        }
    }
}

