/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Schema"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotTableSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableSchema.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/schema")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSchema")
    @ApiOperation(value="Get table schema", notes="Read table schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found")})
    public String getTableSchema(@ApiParam(value="Table name (without type)", required=true) @PathParam(value="tableName") String tableName) {
        Schema schema = this._pinotHelixResourceManager.getTableSchema(tableName);
        if (schema != null) {
            return schema.toPrettyJsonString();
        }
        throw new ControllerApplicationException(LOGGER, "Schema not found for table: " + tableName, Response.Status.NOT_FOUND);
    }
}

