/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixManager;
import org.apache.helix.model.IdealState;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.exception.SchemaNotFoundException;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.controllerjob.ControllerJobType;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.TableSegmentValidationInfo;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.exception.InvalidTableConfigException;
import org.apache.pinot.controller.api.exception.TableAlreadyExistsException;
import org.apache.pinot.controller.api.resources.ConfigSuccessResponse;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.api.resources.ServerRebalanceJobStatusResponse;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.resources.TableAndSchemaConfig;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.controller.helix.core.rebalance.TableRebalanceProgressStats;
import org.apache.pinot.controller.helix.core.rebalance.TableRebalancer;
import org.apache.pinot.controller.recommender.RecommenderDriver;
import org.apache.pinot.controller.tuner.TableConfigTunerUtils;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.controller.util.TableIngestionStatusHelper;
import org.apache.pinot.controller.util.TableMetadataReader;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.ManualAuthorization;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableStats;
import org.apache.pinot.spi.config.table.TableStatus;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.apache.pinot.spi.utils.retry.RetryPolicy;
import org.apache.zookeeper.data.Stat;
import org.glassfish.grizzly.http.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotTableRestletResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotTableRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    ExecutorService _executorService;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Inject
    Executor _executor;
    @Inject
    HttpClientConnectionManager _connectionManager;

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Adds a table", notes="Adds a table")
    @ManualAuthorization
    public ConfigSuccessResponse addTable(String tableConfigStr, @ApiParam(value="comma separated list of validation type(s) to skip. supported types: (ALL|TASK|UPSERT)") @QueryParam(value="validationTypesToSkip") @Nullable String typesToSkip, @Context HttpHeaders httpHeaders, @Context Request request) {
        String tableName;
        TableConfig tableConfig;
        Pair tableConfigAndUnrecognizedProperties;
        try {
            tableConfigAndUnrecognizedProperties = JsonUtils.stringToObjectAndUnrecognizedProperties((String)tableConfigStr, TableConfig.class);
            tableConfig = (TableConfig)tableConfigAndUnrecognizedProperties.getLeft();
            tableName = tableConfig.getTableName();
            String endpointUrl = request.getRequestURL().toString();
            AccessControlUtils.validatePermission(tableName, AccessType.CREATE, httpHeaders, endpointUrl, this._accessControlFactory.create());
            if (!this._accessControlFactory.create().hasAccess(httpHeaders, TargetType.TABLE, tableName, "CreateTable")) {
                throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
            }
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigTunerUtils.applyTunerConfigs(this._pinotHelixResourceManager, tableConfig, schema, Collections.emptyMap());
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema, (String)typesToSkip, (boolean)this._controllerConf.isDisableIngestionGroovy());
            boolean allowTableNameWithDatabase = this._controllerConf.getProperty("allow.table.name.with.database", false);
            TableConfigUtils.validateTableName((TableConfig)tableConfig, (boolean)allowTableNameWithDatabase);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            try {
                TableConfigUtils.ensureMinReplicas((TableConfig)tableConfig, (int)this._controllerConf.getDefaultTableMinReplicas());
                TableConfigUtils.ensureStorageQuotaConstraints((TableConfig)tableConfig, (String)this._controllerConf.getDimTableMaxSize());
                this.checkHybridTableConfig(TableNameBuilder.extractRawTableName((String)tableName), tableConfig);
            }
            catch (Exception e) {
                throw new InvalidTableConfigException(e);
            }
            this._pinotHelixResourceManager.addTable(tableConfig);
            return new ConfigSuccessResponse("Table " + tableName + " successfully added", (Map)tableConfigAndUnrecognizedProperties.getRight());
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_ADD_ERROR, 1L);
            if (e instanceof InvalidTableConfigException) {
                String errStr = String.format("Invalid table config for table %s: %s", tableName, e.getMessage());
                throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
            }
            if (e instanceof TableAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/tables/recommender")
    @Authorize(targetType=TargetType.CLUSTER, action="RecommendConfig")
    @ApiOperation(value="Recommend config", notes="Recommend a config with input json")
    public String recommendConfig(String inputStr) {
        try {
            return RecommenderDriver.run(inputStr);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTable")
    @ApiOperation(value="Lists all tables in cluster", notes="Lists all tables in cluster")
    public String listTables(@ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Task type") @QueryParam(value="taskType") String taskType, @ApiParam(value="name|creationTime|lastModifiedTime") @QueryParam(value="sortType") String sortTypeStr, @ApiParam(value="true|false") @QueryParam(value="sortAsc") @DefaultValue(value="true") boolean sortAsc) {
        try {
            List<String> tableNames;
            List<String> tableNamesWithType;
            SortType sortType;
            TableType tableType = null;
            if (tableTypeStr != null) {
                tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
            }
            SortType sortType2 = sortType = sortTypeStr != null ? SortType.valueOf(sortTypeStr.toUpperCase()) : SortType.NAME;
            List<String> list = tableType == null ? this._pinotHelixResourceManager.getAllTables() : (tableNamesWithType = tableType == TableType.REALTIME ? this._pinotHelixResourceManager.getAllRealtimeTables() : this._pinotHelixResourceManager.getAllOfflineTables());
            if (StringUtils.isNotBlank((CharSequence)taskType)) {
                HashSet<String> tableNamesForTaskType = new HashSet<String>();
                for (String tableNameWithType : tableNamesWithType) {
                    TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
                    if (tableConfig == null || tableConfig.getTaskConfig() == null || !tableConfig.getTaskConfig().isTaskTypeEnabled(taskType)) continue;
                    tableNamesForTaskType.add(tableNameWithType);
                }
                tableNamesWithType.retainAll(tableNamesForTaskType);
            }
            if (sortType == SortType.NAME) {
                if (tableType == null && StringUtils.isBlank((CharSequence)taskType)) {
                    List rawTableNames = tableNamesWithType.stream().map(TableNameBuilder::extractRawTableName).distinct().collect(Collectors.toList());
                    rawTableNames.sort(sortAsc ? null : Comparator.reverseOrder());
                    tableNames = rawTableNames;
                } else {
                    tableNamesWithType.sort(sortAsc ? null : Comparator.reverseOrder());
                    tableNames = tableNamesWithType;
                }
            } else {
                IntComparator comparator;
                int sortFactor = sortAsc ? 1 : -1;
                ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
                int numTables = tableNamesWithType.size();
                ArrayList<String> zkPaths = new ArrayList<String>(numTables);
                for (String tableNameWithType : tableNamesWithType) {
                    zkPaths.add(ZKMetadataProvider.constructPropertyStorePathForResourceConfig((String)tableNameWithType));
                }
                Stat[] stats = propertyStore.getStats(zkPaths, AccessOption.PERSISTENT);
                for (int i2 = 0; i2 < numTables; ++i2) {
                    Preconditions.checkState((stats[i2] != null ? 1 : 0) != 0, (String)"Failed to read ZK stats for table: %s", (Object)tableNamesWithType.get(i2));
                }
                if (sortType == SortType.CREATIONTIME) {
                    comparator = (i, j) -> Long.compare(stats[i].getCtime(), stats[j].getCtime()) * sortFactor;
                } else {
                    assert (sortType == SortType.LASTMODIFIEDTIME);
                    comparator = (i, j) -> Long.compare(stats[i].getMtime(), stats[j].getMtime()) * sortFactor;
                }
                Swapper swapper = (i, j) -> {
                    Stat tempStat = stats[i];
                    stats[i] = stats[j];
                    stats[j] = tempStat;
                    String tempTableName = (String)tableNamesWithType.get(i);
                    tableNamesWithType.set(i, (String)tableNamesWithType.get(j));
                    tableNamesWithType.set(j, tempTableName);
                };
                Arrays.quickSort((int)0, (int)numTables, (IntComparator)comparator, (Swapper)swapper);
                tableNames = tableNamesWithType;
            }
            return JsonUtils.newObjectNode().set("tables", JsonUtils.objectToJsonNode(tableNames)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String listTableConfigs(String tableName, @Nullable String tableTypeStr) {
        try {
            TableConfig tableConfig;
            ObjectNode ret = JsonUtils.newObjectNode();
            if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getOfflineTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            }
            if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @ManualAuthorization
    @Path(value="/tables/{tableName}")
    @ApiOperation(value="Lists the table configs")
    public String alterTableStateOrListTableConfig(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="enable|disable|drop") @QueryParam(value="state") String stateStr, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr, @Context HttpHeaders httpHeaders, @Context Request request) {
        try {
            if (StringUtils.isBlank((CharSequence)stateStr)) {
                if (!this._accessControlFactory.create().hasAccess(httpHeaders, TargetType.TABLE, tableName, "GetTableConfig")) {
                    throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
                }
                return this.listTableConfigs(tableName, tableTypeStr);
            }
            StateType stateType = Constants.validateState(stateStr);
            TableType tableType = Constants.validateTableType(tableTypeStr);
            String endpointUrl = request.getRequestURL().toString();
            AccessControlUtils.validatePermission(tableName, AccessType.UPDATE, httpHeaders, endpointUrl, this._accessControlFactory.create());
            AccessControl accessControl = this._accessControlFactory.create();
            switch (stateType) {
                case ENABLE: {
                    if (accessControl.hasAccess(httpHeaders, TargetType.TABLE, tableName, "EnableTable")) break;
                    throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
                }
                case DISABLE: {
                    if (accessControl.hasAccess(httpHeaders, TargetType.TABLE, tableName, "DisableTable")) break;
                    throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
                }
                case DROP: {
                    if (accessControl.hasAccess(httpHeaders, TargetType.TABLE, tableName, "DeleteTable")) break;
                    throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
                }
                default: {
                    throw new ControllerApplicationException(LOGGER, "Invalid state type: " + stateType, Response.Status.BAD_REQUEST);
                }
            }
            ArrayNode ret = JsonUtils.newArrayNode();
            boolean tableExists = false;
            if (tableType != TableType.REALTIME && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
                ObjectNode offline = JsonUtils.newObjectNode();
                tableExists = true;
                offline.put("tableName", offlineTableName);
                offline.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(offlineTableName, stateType)));
                ret.add((JsonNode)offline);
            }
            if (tableType != TableType.OFFLINE && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
                ObjectNode realtime = JsonUtils.newObjectNode();
                tableExists = true;
                realtime.put("tableName", realtimeTableName);
                realtime.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(realtimeTableName, stateType)));
                ret.add((JsonNode)realtime);
            }
            if (tableExists) {
                return ret.toString();
            }
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' does not exist", Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tables/{tableName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteTable")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a table", notes="Deletes a table")
    public SuccessResponse deleteTable(@ApiParam(value="Name of the table to delete", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Retention period for the table segments (e.g. 12h, 3d); If not set, the retention period will default to the first config that's not null: the cluster setting, then '7d'. Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        LinkedList<String> tablesDeleted = new LinkedList<String>();
        try {
            boolean tableExist = false;
            if (this.verifyTableType(tableName, tableType, TableType.OFFLINE)) {
                tableExist = this._pinotHelixResourceManager.hasOfflineTable(tableName);
                this._pinotHelixResourceManager.deleteOfflineTable(tableName, retentionPeriod);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.OFFLINE.tableNameWithType(tableName));
                }
            }
            if (this.verifyTableType(tableName, tableType, TableType.REALTIME)) {
                tableExist = this._pinotHelixResourceManager.hasRealtimeTable(tableName);
                this._pinotHelixResourceManager.deleteRealtimeTable(tableName, retentionPeriod);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.REALTIME.tableNameWithType(tableName));
                }
            }
            if (!tablesDeleted.isEmpty()) {
                return new SuccessResponse("Tables: " + tablesDeleted + " deleted");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' with type " + tableType + " does not exist", Response.Status.NOT_FOUND);
    }

    private boolean verifyTableType(String tableName, TableType tableType, TableType expectedType) {
        if (tableType != null && tableType != expectedType) {
            return false;
        }
        TableType typeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        return typeFromTableName == null || typeFromTableName == expectedType;
    }

    @PUT
    @Path(value="/tables/{tableName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UpdateTableConfig")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates table config for a table", notes="Updates table config for a table")
    public ConfigSuccessResponse updateTableConfig(@ApiParam(value="Name of the table to update", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="comma separated list of validation type(s) to skip. supported types: (ALL|TASK|UPSERT)") @QueryParam(value="validationTypesToSkip") @Nullable String typesToSkip, String tableConfigString) throws Exception {
        TableConfig tableConfig;
        Pair tableConfigJsonPojoWithUnparsableProps;
        try {
            tableConfigJsonPojoWithUnparsableProps = JsonUtils.stringToObjectAndUnrecognizedProperties((String)tableConfigString, TableConfig.class);
            tableConfig = (TableConfig)tableConfigJsonPojoWithUnparsableProps.getLeft();
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema, (String)typesToSkip, (boolean)this._controllerConf.isDisableIngestionGroovy());
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s with error: %s", tableName, e.getMessage());
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            String tableNameWithType = tableConfig.getTableName();
            if (!TableNameBuilder.forType((TableType)tableConfig.getTableType()).tableNameWithType(tableName).equals(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Request table " + tableName + " does not match table name in the body " + tableNameWithType, Response.Status.BAD_REQUEST);
            }
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Table " + tableNameWithType + " does not exist", Response.Status.NOT_FOUND);
            }
            try {
                TableConfigUtils.ensureMinReplicas((TableConfig)tableConfig, (int)this._controllerConf.getDefaultTableMinReplicas());
                TableConfigUtils.ensureStorageQuotaConstraints((TableConfig)tableConfig, (String)this._controllerConf.getDimTableMaxSize());
                this.checkHybridTableConfig(TableNameBuilder.extractRawTableName((String)tableName), tableConfig);
            }
            catch (Exception e) {
                throw new InvalidTableConfigException(e);
            }
            this._pinotHelixResourceManager.updateTableConfig(tableConfig);
        }
        catch (InvalidTableConfigException e) {
            String errStr = String.format("Failed to update configuration for %s due to: %s", tableName, e.getMessage());
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw e;
        }
        return new ConfigSuccessResponse("Table config updated for " + tableName, (Map)tableConfigJsonPojoWithUnparsableProps.getRight());
    }

    @POST
    @Path(value="/tables/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table", notes="This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    @ManualAuthorization
    public ObjectNode checkTableConfig(String tableConfigStr, @ApiParam(value="comma separated list of validation type(s) to skip. supported types: (ALL|TASK|UPSERT)") @QueryParam(value="validationTypesToSkip") @Nullable String typesToSkip, @Context HttpHeaders httpHeaders, @Context Request request) {
        Pair tableConfig;
        try {
            tableConfig = JsonUtils.stringToObjectAndUnrecognizedProperties((String)tableConfigStr, TableConfig.class);
        }
        catch (IOException e) {
            String msg = String.format("Invalid table config json string: %s", tableConfigStr);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        String tableName = ((TableConfig)tableConfig.getLeft()).getTableName();
        String endpointUrl = request.getRequestURL().toString();
        AccessControlUtils.validatePermission(tableName, AccessType.READ, httpHeaders, endpointUrl, this._accessControlFactory.create());
        if (!this._accessControlFactory.create().hasAccess(httpHeaders, TargetType.TABLE, tableName, "ValidateTableConfigs")) {
            throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
        }
        ObjectNode validationResponse = this.validateConfig((TableConfig)tableConfig.getLeft(), this._pinotHelixResourceManager.getSchemaForTableConfig((TableConfig)tableConfig.getLeft()), typesToSkip);
        validationResponse.set("unrecognizedProperties", JsonUtils.objectToJsonNode((Object)tableConfig.getRight()));
        return validationResponse;
    }

    @Deprecated
    @POST
    @Path(value="/tables/validateTableAndSchema")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table along with specified schema", notes="Deprecated. Use /tableConfigs/validate instead.Validate given table config and schema. If specified schema is null, attempt to retrieve schema using the table name. This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    @ManualAuthorization
    public String validateTableAndSchema(TableAndSchemaConfig tableSchemaConfig, @ApiParam(value="comma separated list of validation type(s) to skip. supported types: (ALL|TASK|UPSERT)") @QueryParam(value="validationTypesToSkip") @Nullable String typesToSkip, @Context HttpHeaders httpHeaders, @Context Request request) {
        TableConfig tableConfig = tableSchemaConfig.getTableConfig();
        Schema schema = tableSchemaConfig.getSchema();
        if (schema == null) {
            schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
        }
        String schemaName = schema != null ? schema.getSchemaName() : null;
        String endpointUrl = request.getRequestURL().toString();
        AccessControlUtils.validatePermission(schemaName, AccessType.READ, httpHeaders, endpointUrl, this._accessControlFactory.create());
        if (!this._accessControlFactory.create().hasAccess(httpHeaders, TargetType.TABLE, tableConfig.getTableName(), "ValidateTableConfigs")) {
            throw new ControllerApplicationException(LOGGER, "Permission denied", Response.Status.FORBIDDEN);
        }
        return this.validateConfig(tableSchemaConfig.getTableConfig(), schema, typesToSkip).toString();
    }

    private ObjectNode validateConfig(TableConfig tableConfig, Schema schema, @Nullable String typesToSkip) {
        try {
            if (schema == null) {
                throw new SchemaNotFoundException("Got empty schema");
            }
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema, (String)typesToSkip, (boolean)this._controllerConf.isDisableIngestionGroovy());
            ObjectNode tableConfigValidateStr = JsonUtils.newObjectNode();
            if (tableConfig.getTableType() == TableType.OFFLINE) {
                tableConfigValidateStr.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            } else {
                tableConfigValidateStr.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return tableConfigValidateStr;
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s. %s", tableConfig.getTableName(), e.getMessage());
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @Path(value="/tables/{tableName}/rebalance")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="RebalanceTable")
    @ApiOperation(value="Rebalances a table (reassign instances and segments for a table)", notes="Rebalances a table (reassign instances and segments for a table)")
    public RebalanceResult rebalance(@ApiParam(value="Name of the table to rebalance", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to rebalance table in dry-run mode") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun, @ApiParam(value="Whether to reassign instances before reassigning segments") @DefaultValue(value="false") @QueryParam(value="reassignInstances") boolean reassignInstances, @ApiParam(value="Whether to reassign CONSUMING segments for real-time table") @DefaultValue(value="false") @QueryParam(value="includeConsuming") boolean includeConsuming, @ApiParam(value="Whether to rebalance table in bootstrap mode (regardless of minimum segment movement, reassign all segments in a round-robin fashion as if adding new segments to an empty table)") @DefaultValue(value="false") @QueryParam(value="bootstrap") boolean bootstrap, @ApiParam(value="Whether to allow downtime for the rebalance") @DefaultValue(value="false") @QueryParam(value="downtime") boolean downtime, @ApiParam(value="For no-downtime rebalance, minimum number of replicas to keep alive during rebalance, or maximum number of replicas allowed to be unavailable if value is negative") @DefaultValue(value="1") @QueryParam(value="minAvailableReplicas") int minAvailableReplicas, @ApiParam(value="Whether to use best-efforts to rebalance (not fail the rebalance when the no-downtime contract cannot be achieved)") @DefaultValue(value="false") @QueryParam(value="bestEfforts") boolean bestEfforts, @ApiParam(value="How often to check if external view converges with ideal states") @DefaultValue(value="1000") @QueryParam(value="externalViewCheckIntervalInMs") long externalViewCheckIntervalInMs, @ApiParam(value="How long to wait till external view converges with ideal states") @DefaultValue(value="3600000") @QueryParam(value="externalViewStabilizationTimeoutInMs") long externalViewStabilizationTimeoutInMs, @ApiParam(value="Whether to update segment target tier as part of the rebalance") @DefaultValue(value="false") @QueryParam(value="updateTargetTier") boolean updateTargetTier) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("dryRun", (Object)dryRun);
        rebalanceConfig.addProperty("reassignInstances", (Object)reassignInstances);
        rebalanceConfig.addProperty("includeConsuming", (Object)includeConsuming);
        rebalanceConfig.addProperty("bootstrap", (Object)bootstrap);
        rebalanceConfig.addProperty("downtime", (Object)downtime);
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)minAvailableReplicas);
        rebalanceConfig.addProperty("bestEfforts", (Object)bestEfforts);
        rebalanceConfig.addProperty("externalViewCheckIntervalInMs", (Object)externalViewCheckIntervalInMs);
        rebalanceConfig.addProperty("externalViewStabilizationTimeoutInMs", (Object)externalViewStabilizationTimeoutInMs);
        rebalanceConfig.addProperty("updateTargetTier", (Object)updateTargetTier);
        rebalanceConfig.addProperty("jobId", (Object)TableRebalancer.createUniqueRebalanceJobIdentifier());
        try {
            if (dryRun || downtime) {
                return this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig, false);
            }
            rebalanceConfig.setProperty("dryRun", (Object)true);
            RebalanceResult dryRunResult = this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig, false);
            if (dryRunResult.getStatus() == RebalanceResult.Status.DONE) {
                rebalanceConfig.setProperty("dryRun", (Object)false);
                this._executorService.submit(() -> this.lambda$rebalance$3(tableNameWithType, (Configuration)rebalanceConfig));
                return new RebalanceResult(dryRunResult.getJobId(), RebalanceResult.Status.IN_PROGRESS, "In progress, check controller logs for updates", dryRunResult.getInstanceAssignment(), dryRunResult.getTierInstanceAssignment(), dryRunResult.getSegmentAssignment());
            }
            return dryRunResult;
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/state")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetState")
    @ApiOperation(value="Get current table state", notes="Get current table state")
    public String getTableState(@ApiParam(value="Name of the table to get its state", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=true) @QueryParam(value="type") String tableTypeStr) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        try {
            ObjectNode data = JsonUtils.newObjectNode();
            data.put("state", this._pinotHelixResourceManager.isTableEnabled(tableNameWithType) ? "enabled" : "disabled");
            return data.toString();
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table: " + tableNameWithType, Response.Status.NOT_FOUND);
        }
    }

    @PUT
    @Path(value="/tables/{tableName}/state")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable a table", notes="Enable/disable a table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleTableState(@ApiParam(value="Table name", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="enable|disable", required=true) @QueryParam(value="state") String state) {
        StateType stateType;
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        if (StateType.ENABLE.name().equalsIgnoreCase(state)) {
            stateType = StateType.ENABLE;
        } else if (StateType.DISABLE.name().equalsIgnoreCase(state)) {
            stateType = StateType.DISABLE;
        } else {
            throw new ControllerApplicationException(LOGGER, "Unknown state '" + state + "'", Response.Status.BAD_REQUEST);
        }
        if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' does not exist", Response.Status.NOT_FOUND);
        }
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.toggleTableState(tableNameWithType, stateType);
        if (response.isSuccessful()) {
            return new SuccessResponse("Request to " + state + " table '" + tableNameWithType + "' is successful");
        }
        throw new ControllerApplicationException(LOGGER, "Failed to " + state + " table '" + tableNameWithType + "': " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
    }

    @GET
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @Path(value="/rebalanceStatus/{jobId}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetRebalanceStatus")
    @ApiOperation(value="Gets detailed stats of a rebalance operation", notes="Gets detailed stats of a rebalance operation")
    public ServerRebalanceJobStatusResponse rebalanceStatus(@ApiParam(value="Rebalance Job Id", required=true) @PathParam(value="jobId") String jobId) throws JsonProcessingException {
        Map<String, String> controllerJobZKMetadata = this._pinotHelixResourceManager.getControllerJobZKMetadata(jobId, ControllerJobType.TABLE_REBALANCE);
        if (controllerJobZKMetadata == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find controller job id: " + jobId, Response.Status.NOT_FOUND);
        }
        TableRebalanceProgressStats tableRebalanceProgressStats = (TableRebalanceProgressStats)JsonUtils.stringToObject((String)controllerJobZKMetadata.get("REBALANCE_PROGRESS_STATS"), TableRebalanceProgressStats.class);
        long timeSinceStartInSecs = 0L;
        if (!tableRebalanceProgressStats.getStatus().equals((Object)RebalanceResult.Status.DONE)) {
            timeSinceStartInSecs = (System.currentTimeMillis() - tableRebalanceProgressStats.getStartTimeMs()) / 1000L;
        }
        ServerRebalanceJobStatusResponse serverRebalanceJobStatusResponse = new ServerRebalanceJobStatusResponse();
        serverRebalanceJobStatusResponse.setTableRebalanceProgressStats(tableRebalanceProgressStats);
        serverRebalanceJobStatusResponse.setTimeElapsedSinceStartInSeconds(timeSinceStartInSecs);
        return serverRebalanceJobStatusResponse;
    }

    @GET
    @Path(value="/tables/{tableName}/stats")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="table stats", notes="Provides metadata info/stats about the table.")
    public String getTableStats(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        TableStats tableStats;
        String tableNameWithType;
        ObjectNode ret = JsonUtils.newObjectNode();
        if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.OFFLINE).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.OFFLINE.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.REALTIME.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        return ret.toString();
    }

    private String constructTableNameWithType(String tableName, String tableTypeStr) {
        TableType tableType;
        try {
            tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Illegal table type: " + tableTypeStr, Response.Status.BAD_REQUEST);
        }
        return TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
    }

    private void checkHybridTableConfig(String rawTableName, TableConfig tableConfig) {
        if (tableConfig.getTableType() == TableType.REALTIME) {
            if (this._pinotHelixResourceManager.hasOfflineTable(rawTableName)) {
                TableConfigUtils.verifyHybridTableConfigs((String)rawTableName, (TableConfig)this._pinotHelixResourceManager.getOfflineTableConfig(rawTableName), (TableConfig)tableConfig);
            }
        } else if (this._pinotHelixResourceManager.hasRealtimeTable(rawTableName)) {
            TableConfigUtils.verifyHybridTableConfigs((String)rawTableName, (TableConfig)tableConfig, (TableConfig)this._pinotHelixResourceManager.getRealtimeTableConfig(rawTableName));
        }
    }

    @GET
    @Path(value="/tables/{tableName}/status")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="table status", notes="Provides status of the table including ingestion status")
    public String getTableStatus(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            TableType tableType = Constants.validateTableType(tableTypeStr);
            if (tableType == null) {
                throw new ControllerApplicationException(LOGGER, "Table type should either be realtime|offline", Response.Status.BAD_REQUEST);
            }
            String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Specified table name: " + tableName + " of type: " + tableTypeStr + " does not exist.", Response.Status.BAD_REQUEST);
            }
            TableStatus.IngestionStatus ingestionStatus = null;
            ingestionStatus = TableType.OFFLINE == tableType ? TableIngestionStatusHelper.getOfflineTableIngestionStatus(tableNameWithType, this._pinotHelixResourceManager, this._pinotHelixTaskResourceManager) : TableIngestionStatusHelper.getRealtimeTableIngestionStatus(tableNameWithType, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000, this._executor, this._connectionManager, this._pinotHelixResourceManager);
            TableStatus tableStatus = new TableStatus(ingestionStatus);
            return JsonUtils.objectToPrettyString((Object)tableStatus);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to get status (ingestion status) for table %s. Reason: %s", tableName, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="tables/{tableName}/metadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the aggregate metadata of all segments for a table", notes="Get the aggregate metadata of all segments for a table")
    public String getTableAggregateMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Columns name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) {
        String segmentsMetadata;
        LOGGER.info("Received a request to fetch aggregate metadata for a table {}", (Object)tableName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == TableType.REALTIME) {
            throw new ControllerApplicationException(LOGGER, "Table type : " + tableTypeStr + " not yet supported.", Response.Status.NOT_IMPLEMENTED);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        int numReplica = tableConfig == null ? 1 : tableConfig.getReplication();
        try {
            JsonNode segmentsMetadataJson = this.getAggregateMetadataFromServer(tableNameWithType, columns, numReplica);
            segmentsMetadata = JsonUtils.objectToPrettyString((Object)segmentsMetadataJson);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IOException ioe) {
            throw new ControllerApplicationException(LOGGER, "Error parsing Pinot server response: " + ioe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ioe);
        }
        return segmentsMetadata;
    }

    private JsonNode getAggregateMetadataFromServer(String tableNameWithType, List<String> columns, int numReplica) throws InvalidConfigException, IOException {
        TableMetadataReader tableMetadataReader = new TableMetadataReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
        return tableMetadataReader.getAggregateTableMetadata(tableNameWithType, columns, numReplica, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
    }

    @GET
    @Path(value="table/{tableName}/jobs")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetControllerJobs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of controller jobs for this table", notes="Get list of controller jobs for this table")
    public Map<String, Map<String, String>> getControllerJobs(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Comma separated list of job types") @QueryParam(value="jobTypes") @Nullable String jobTypesString) {
        TableType tableTypeFromRequest = Constants.validateTableType(tableTypeStr);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableTypeFromRequest, LOGGER);
        Set<ControllerJobType> validJobTypes = java.util.Arrays.stream(ControllerJobType.values()).collect(Collectors.toSet());
        Set jobTypesToFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)jobTypesString)) {
            try {
                jobTypesToFilter = new HashSet<String>(java.util.Arrays.asList(StringUtils.split((String)jobTypesString, (char)','))).stream().map(type -> ControllerJobType.valueOf((String)type)).collect(Collectors.toSet());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Valid Types are: " + validJobTypes);
            }
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (String tableNameWithType : tableNamesWithType) {
            result.putAll(this._pinotHelixResourceManager.getAllJobsForTable(tableNameWithType, jobTypesToFilter == null ? validJobTypes : jobTypesToFilter));
        }
        return result;
    }

    @POST
    @Path(value="tables/{tableName}/timeBoundary")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UpdateTableConfig")
    @ApiOperation(value="Set hybrid table query time boundary based on offline segments' metadata", notes="Set hybrid table query time boundary based on offline segments' metadata")
    @Produces(value={"application/json"})
    public SuccessResponse setTimeBoundary(@ApiParam(value="Name of the hybrid table (without type suffix)", required=true) @PathParam(value="tableName") String tableName) throws Exception {
        if (!this._pinotHelixResourceManager.hasRealtimeTable(tableName) || !this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
            throw new ControllerApplicationException(LOGGER, "Table isn't a hybrid table", Response.Status.NOT_FOUND);
        }
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        long timeBoundaryMs = this.validateSegmentStateForTable(offlineTableName);
        if (timeBoundaryMs < 0L) {
            throw new ControllerApplicationException(LOGGER, "No segments found for offline table : " + offlineTableName + ". Could not update time boundary.", Response.Status.SERVICE_UNAVAILABLE);
        }
        IdealState idealState = HelixHelper.updateIdealState((HelixManager)this._pinotHelixResourceManager.getHelixZkManager(), (String)offlineTableName, is -> {
            is.getRecord().setSimpleField("HYBRID_TABLE_TIME_BOUNDARY", Long.toString(timeBoundaryMs));
            return is;
        }, (RetryPolicy)RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)1000L, (double)1.2f));
        if (idealState == null) {
            throw new ControllerApplicationException(LOGGER, "Could not update time boundary", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new SuccessResponse("Time boundary successfully updated to: " + timeBoundaryMs);
    }

    @DELETE
    @Path(value="tables/{tableName}/timeBoundary")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteTimeBoundary")
    @ApiOperation(value="Delete hybrid table query time boundary", notes="Delete hybrid table query time boundary")
    @Produces(value={"application/json"})
    public SuccessResponse deleteTimeBoundary(@ApiParam(value="Name of the hybrid table (without type suffix)", required=true) @PathParam(value="tableName") String tableName) {
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        if (!this._pinotHelixResourceManager.hasTable(offlineTableName)) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table: " + offlineTableName, Response.Status.NOT_FOUND);
        }
        IdealState idealState = HelixHelper.updateIdealState((HelixManager)this._pinotHelixResourceManager.getHelixZkManager(), (String)offlineTableName, is -> {
            is.getRecord().getSimpleFields().remove("HYBRID_TABLE_TIME_BOUNDARY");
            return is;
        }, (RetryPolicy)RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)1000L, (double)1.2f));
        if (idealState == null) {
            throw new ControllerApplicationException(LOGGER, "Could not remove time boundary", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new SuccessResponse("Time boundary successfully removed");
    }

    private long validateSegmentStateForTable(String offlineTableName) throws InvalidConfigException, JsonProcessingException {
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(offlineTableName);
        BiMap<String, String> serverEndPoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, serverEndPoints);
        ArrayList<String> serverUrls = new ArrayList<String>();
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String reloadTaskStatusEndpoint = endpoint + "/tables/" + offlineTableName + "/allSegmentsLoaded";
            serverUrls.add(reloadTaskStatusEndpoint);
        }
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, null, true, 10000);
        if (serviceResponse._failedResponseCount > 0) {
            throw new ControllerApplicationException(LOGGER, "Could not validate table segment status", Response.Status.SERVICE_UNAVAILABLE);
        }
        long timeBoundaryMs = -1L;
        for (String response : serviceResponse._httpResponses.values()) {
            TableSegmentValidationInfo tableSegmentValidationInfo = (TableSegmentValidationInfo)JsonUtils.stringToObject((String)response, TableSegmentValidationInfo.class);
            if (!tableSegmentValidationInfo.isValid()) {
                throw new ControllerApplicationException(LOGGER, "Table segment validation failed", Response.Status.PRECONDITION_FAILED);
            }
            timeBoundaryMs = Math.max(timeBoundaryMs, tableSegmentValidationInfo.getMaxEndTimeMs());
        }
        return timeBoundaryMs;
    }

    private /* synthetic */ void lambda$rebalance$3(String tableNameWithType, Configuration rebalanceConfig) {
        try {
            this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, rebalanceConfig, true);
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }

    private static enum SortType {
        NAME,
        CREATIONTIME,
        LASTMODIFIEDTIME;

    }
}

