/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.InstanceInfo;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.services.PinotBrokerService;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class PinotBrokerRestletResource
implements PinotBrokerService {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotBrokerRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @Override
    public Map<String, Map<String, List<String>>> listBrokersMapping(String state) {
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>();
        resultMap.put("tenants", this.getTenantsToBrokersMapping(state));
        resultMap.put("tables", this.getTablesToBrokersMapping(state));
        return resultMap;
    }

    @Override
    public Map<String, List<String>> getTenantsToBrokersMapping(String state) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        this._pinotHelixResourceManager.getAllBrokerTenantNames().stream().forEach(tenant -> resultMap.put((String)tenant, this.getBrokersForTenant((String)tenant, state)));
        return resultMap;
    }

    @Override
    public List<String> getBrokersForTenant(String tenantName, String state) {
        List<InstanceInfo> instanceInfoList = this.getBrokersForTenantV2(tenantName, state);
        List<String> tenantBrokers = instanceInfoList.stream().map(InstanceInfo::getInstanceName).collect(Collectors.toList());
        return tenantBrokers;
    }

    @Override
    public Map<String, List<String>> getTablesToBrokersMapping(String state) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        this._pinotHelixResourceManager.getAllRawTables().stream().forEach(table -> resultMap.put((String)table, this.getBrokersForTable((String)table, null, state)));
        return resultMap;
    }

    @Override
    public List<String> getBrokersForTable(String tableName, String tableTypeStr, String state) {
        List<InstanceInfo> instanceInfoList = this.getBrokersForTableV2(tableName, tableTypeStr, state);
        return instanceInfoList.stream().map(InstanceInfo::getInstanceName).collect(Collectors.toList());
    }

    @Override
    public Map<String, Map<String, List<InstanceInfo>>> listBrokersMappingV2(String state) {
        HashMap<String, Map<String, List<InstanceInfo>>> resultMap = new HashMap<String, Map<String, List<InstanceInfo>>>();
        resultMap.put("tenants", this.getTenantsToBrokersMappingV2(state));
        resultMap.put("tables", this.getTablesToBrokersMappingV2(state));
        return resultMap;
    }

    @Override
    public Map<String, List<InstanceInfo>> getTenantsToBrokersMappingV2(String state) {
        HashMap<String, List<InstanceInfo>> resultMap = new HashMap<String, List<InstanceInfo>>();
        this._pinotHelixResourceManager.getAllBrokerTenantNames().stream().forEach(tenant -> resultMap.put((String)tenant, this.getBrokersForTenantV2((String)tenant, state)));
        return resultMap;
    }

    @Override
    public List<InstanceInfo> getBrokersForTenantV2(String tenantName, String state) {
        if (!this._pinotHelixResourceManager.getAllBrokerTenantNames().contains(tenantName)) {
            throw new ControllerApplicationException(LOGGER, String.format("Tenant '%s' not found.", tenantName), Response.Status.NOT_FOUND);
        }
        HashSet<InstanceConfig> tenantBrokers = new HashSet<InstanceConfig>(this._pinotHelixResourceManager.getAllInstancesConfigsForBrokerTenant(tenantName));
        Set<InstanceInfo> instanceInfoSet = tenantBrokers.stream().map(x -> new InstanceInfo(x.getInstanceName(), x.getHostName(), Integer.parseInt(x.getPort()))).collect(Collectors.toSet());
        this.applyStateChanges(instanceInfoSet, state);
        return ImmutableList.copyOf(instanceInfoSet);
    }

    @Override
    public Map<String, List<InstanceInfo>> getTablesToBrokersMappingV2(String state) {
        HashMap<String, List<InstanceInfo>> resultMap = new HashMap<String, List<InstanceInfo>>();
        this._pinotHelixResourceManager.getAllRawTables().stream().forEach(table -> resultMap.put((String)table, this.getBrokersForTableV2((String)table, null, state)));
        return resultMap;
    }

    @Override
    public List<InstanceInfo> getBrokersForTableV2(String tableName, String tableTypeStr, String state) {
        try {
            List<String> tableNamesWithType = this._pinotHelixResourceManager.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
            if (tableNamesWithType.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, String.format("Table '%s' not found.", tableName), Response.Status.NOT_FOUND);
            }
            HashSet<InstanceConfig> tenantBrokers = new HashSet<InstanceConfig>(this._pinotHelixResourceManager.getBrokerInstancesConfigsFor(tableNamesWithType.get(0)));
            Set<InstanceInfo> instanceInfoSet = tenantBrokers.stream().map(x -> new InstanceInfo(x.getInstanceName(), x.getHostName(), Integer.parseInt(x.getPort()))).collect(Collectors.toSet());
            this.applyStateChanges(instanceInfoSet, state);
            return ImmutableList.copyOf(instanceInfoSet);
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Table '%s' not found.", tableName), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.FORBIDDEN);
        }
    }

    @Override
    public SuccessResponse toggleQueryRateLimiting(String brokerInstanceName, String state) {
        if (brokerInstanceName == null || !brokerInstanceName.startsWith("Broker_")) {
            throw new ControllerApplicationException(LOGGER, String.format("'%s' is not a valid broker instance name.", brokerInstanceName), Response.Status.BAD_REQUEST);
        }
        String stateInUpperCases = state.toUpperCase();
        this.validateQueryQuotaStateChange(stateInUpperCases);
        List<String> liveInstances = this._pinotHelixResourceManager.getOnlineInstanceList();
        if (!liveInstances.contains(brokerInstanceName)) {
            throw new ControllerApplicationException(LOGGER, String.format("Instance '%s' not found.", brokerInstanceName), Response.Status.NOT_FOUND);
        }
        this._pinotHelixResourceManager.toggleQueryQuotaStateForBroker(brokerInstanceName, stateInUpperCases);
        String msg = String.format("Set query rate limiting to: %s for all tables in broker: %s", stateInUpperCases, brokerInstanceName);
        LOGGER.info(msg);
        return new SuccessResponse(msg);
    }

    private void validateQueryQuotaStateChange(String state) {
        if (!"ENABLE".equals(state) && !"DISABLE".equals(state)) {
            throw new ControllerApplicationException(LOGGER, "Invalid query quota state: " + state, Response.Status.BAD_REQUEST);
        }
    }

    private void applyStateChanges(Set<InstanceInfo> brokers, String state) {
        if (state == null) {
            return;
        }
        List<String> onlineInstanceList = this._pinotHelixResourceManager.getOnlineInstanceList();
        Set onlineBrokers = brokers.stream().filter(x -> onlineInstanceList.contains(x.getInstanceName())).collect(Collectors.toSet());
        switch (state) {
            case "ONLINE": {
                brokers.retainAll(onlineBrokers);
                break;
            }
            case "OFFLINE": {
                brokers.removeAll(onlineBrokers);
                break;
            }
        }
    }
}

