/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.debug;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.restlet.resources.SegmentConsumerInfo;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.spi.config.table.TableStatus;

@JsonPropertyOrder(value={"tableName", "numSegments", "numServers", "numBrokers", "segmentDebugInfos", "serverDebugInfos", "brokerDebugInfos"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TableDebugInfo {
    @JsonProperty(value="tableName")
    private final String _tableName;
    @JsonProperty(value="ingestionStatus")
    private final TableStatus.IngestionStatus _ingestionStatus;
    @JsonProperty(value="tableSize")
    private final TableSizeSummary _tableSizeSummary;
    @JsonProperty(value="numSegments")
    private final int _numSegments;
    @JsonProperty(value="numServers")
    private final int _numServers;
    @JsonProperty(value="numBrokers")
    private final int _numBrokers;
    @JsonProperty(value="segmentDebugInfos")
    private final List<SegmentDebugInfo> _segmentDebugInfos;
    @JsonProperty(value="serverDebugInfos")
    private final List<ServerDebugInfo> _serverDebugInfos;
    @JsonProperty(value="brokerDebugInfos")
    private final List<BrokerDebugInfo> _brokerDebugInfos;

    @JsonCreator
    public TableDebugInfo(String tableName, TableStatus.IngestionStatus ingestionStatus, TableSizeSummary tableSizeSummary, int numBrokers, int numServers, int numSegments, List<SegmentDebugInfo> segmentDebugInfos, List<ServerDebugInfo> serverDebugInfos, List<BrokerDebugInfo> brokerDebugInfos) {
        this._tableName = tableName;
        this._ingestionStatus = ingestionStatus;
        this._tableSizeSummary = tableSizeSummary;
        this._numBrokers = numBrokers;
        this._numServers = numServers;
        this._numSegments = numSegments;
        this._segmentDebugInfos = segmentDebugInfos;
        this._serverDebugInfos = serverDebugInfos;
        this._brokerDebugInfos = brokerDebugInfos;
    }

    public String getTableName() {
        return this._tableName;
    }

    public TableStatus.IngestionStatus getIngestionStatus() {
        return this._ingestionStatus;
    }

    public TableSizeSummary getTableSize() {
        return this._tableSizeSummary;
    }

    public int getNumSegments() {
        return this._numSegments;
    }

    public int getNumServers() {
        return this._numServers;
    }

    public int getNumBrokers() {
        return this._numBrokers;
    }

    public List<SegmentDebugInfo> getSegmentDebugInfos() {
        return this._segmentDebugInfos;
    }

    public List<ServerDebugInfo> getServerDebugInfos() {
        return this._serverDebugInfos;
    }

    public List<BrokerDebugInfo> getBrokerDebugInfos() {
        return this._brokerDebugInfos;
    }

    public static class TableSizeSummary {
        private final String _reportedSize;
        private final String _estimatedSize;

        public TableSizeSummary(long reportedSize, long estimatedSize) {
            this._reportedSize = FileUtils.byteCountToDisplaySize((long)reportedSize);
            this._estimatedSize = FileUtils.byteCountToDisplaySize((long)estimatedSize);
        }

        public String getReportedSize() {
            return this._reportedSize;
        }

        public String getEstimatedSize() {
            return this._estimatedSize;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"brokerName", "state"})
    public static class BrokerDebugInfo {
        private final String _brokerName;
        private final String _idealState;
        private final String _externalView;

        @JsonCreator
        public BrokerDebugInfo(@JsonProperty(value="brokerName") String brokerName, @JsonProperty(value="idealState") String idealState, @JsonProperty(value="externalView") String externalView) {
            this._brokerName = brokerName;
            this._idealState = idealState;
            this._externalView = externalView;
        }

        public String getBrokerName() {
            return this._brokerName;
        }

        public String getIdealState() {
            return this._idealState;
        }

        public String getExternalView() {
            return this._externalView;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"serverName", "numErrors", "numMessages"})
    public static class ServerDebugInfo {
        private final String _serverName;
        private final int _numErrors;
        private final int _numMessages;

        @JsonCreator
        public ServerDebugInfo(@JsonProperty(value="serverName") String serverName, @JsonProperty(value="numErrors") int numErrors, @JsonProperty(value="numMessages") int numMessages) {
            this._serverName = serverName;
            this._numErrors = numErrors;
            this._numMessages = numMessages;
        }

        public int getErrors() {
            return this._numErrors;
        }

        public int getNumMessages() {
            return this._numMessages;
        }

        public String getServerName() {
            return this._serverName;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"idealState", "externalView", "segmentSize", "consumerInfo", "errorInfo"})
    public static class SegmentState {
        private final String _idealState;
        private final String _externalView;
        private final String _segmentSize;
        private final SegmentConsumerInfo _consumerInfo;
        private final SegmentErrorInfo _errorInfo;

        @JsonCreator
        public SegmentState(@JsonProperty(value="idealState") String idealState, @JsonProperty(value="externalView") String externalView, @JsonProperty(value="segmentSize") String segmentSize, @JsonProperty(value="consumerInfo") SegmentConsumerInfo consumerInfo, @JsonProperty(value="errorInfo") SegmentErrorInfo errorInfo) {
            this._idealState = idealState;
            this._externalView = externalView;
            this._segmentSize = segmentSize;
            this._consumerInfo = consumerInfo;
            this._errorInfo = errorInfo;
        }

        public String getIdealState() {
            return this._idealState;
        }

        public String getExternalView() {
            return this._externalView;
        }

        public SegmentConsumerInfo getConsumerInfo() {
            return this._consumerInfo;
        }

        public SegmentErrorInfo getErrorInfo() {
            return this._errorInfo;
        }

        public String getSegmentSize() {
            return this._segmentSize;
        }
    }

    @JsonPropertyOrder(value={"segmentName", "serverState"})
    public static class SegmentDebugInfo {
        private final String _segmentName;
        private final Map<String, SegmentState> _serverStateMap;

        @JsonCreator
        public SegmentDebugInfo(@JsonProperty(value="segmentName") String segmentName, @JsonProperty(value="serverState") Map<String, SegmentState> segmentServerState) {
            this._segmentName = segmentName;
            this._serverStateMap = segmentServerState;
        }

        public String getSegmentName() {
            return this._segmentName;
        }

        public Map<String, SegmentState> getServerState() {
            return this._serverStateMap;
        }
    }
}

