/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.controller.recommender.data.generator.BooleanGenerator;
import org.apache.pinot.controller.recommender.data.generator.BytesGenerator;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.NumberGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternMixtureGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternSeasonalGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternSequenceGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternSpikeGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternStringGenerator;
import org.apache.pinot.controller.recommender.data.generator.PatternType;
import org.apache.pinot.controller.recommender.data.generator.RangeDoubleGenerator;
import org.apache.pinot.controller.recommender.data.generator.RangeFloatGenerator;
import org.apache.pinot.controller.recommender.data.generator.RangeIntGenerator;
import org.apache.pinot.controller.recommender.data.generator.RangeLongGenerator;
import org.apache.pinot.controller.recommender.data.generator.StringGenerator;
import org.apache.pinot.controller.recommender.data.generator.TimeGenerator;
import org.apache.pinot.spi.data.FieldSpec;

public class GeneratorFactory {
    private GeneratorFactory() {
    }

    public static Generator getGeneratorFor(FieldSpec.DataType type, Integer cardinality, Double numberOfValuesPerEntry, Integer entryLength, TimeUnit timeUnit) {
        if (type == FieldSpec.DataType.BOOLEAN) {
            return new BooleanGenerator(numberOfValuesPerEntry);
        }
        if (type == FieldSpec.DataType.STRING) {
            return new StringGenerator(cardinality, numberOfValuesPerEntry, entryLength);
        }
        if (type == FieldSpec.DataType.BYTES) {
            return new BytesGenerator(cardinality, entryLength);
        }
        if (timeUnit != null) {
            return new TimeGenerator(cardinality, type, timeUnit);
        }
        return new NumberGenerator(cardinality, type, numberOfValuesPerEntry);
    }

    public static Generator getGeneratorFor(FieldSpec.DataType dataType, int start, int end) {
        switch (dataType) {
            case INT: {
                return new RangeIntGenerator(start, end);
            }
            case LONG: {
                return new RangeLongGenerator(start, end);
            }
            case FLOAT: {
                return new RangeFloatGenerator(start, end);
            }
            case DOUBLE: {
                return new RangeDoubleGenerator(start, end);
            }
        }
        throw new RuntimeException(String.format("Invalid datatype '%s'", dataType));
    }

    public static Generator getGeneratorFor(PatternType patternType, Map<String, Object> templateConfig) {
        switch (patternType) {
            case SEASONAL: {
                return new PatternSeasonalGenerator(templateConfig);
            }
            case SPIKE: {
                return new PatternSpikeGenerator(templateConfig);
            }
            case SEQUENCE: {
                return new PatternSequenceGenerator(templateConfig);
            }
            case STRING: {
                return new PatternStringGenerator(templateConfig);
            }
            case MIXTURE: {
                return new PatternMixtureGenerator(templateConfig);
            }
        }
        throw new RuntimeException(String.format("Invalid template '%s'", new Object[]{patternType}));
    }
}

