/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.relocation;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.config.TierConfigUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.controller.helix.core.rebalance.TableRebalancer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentRelocator
extends ControllerPeriodicTask<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentRelocator.class);
    private final ExecutorService _executorService;

    public SegmentRelocator(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf config, ControllerMetrics controllerMetrics, ExecutorService executorService) {
        super(SegmentRelocator.class.getSimpleName(), config.getSegmentRelocatorFrequencyInSeconds(), config.getSegmentRelocatorInitialDelayInSeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._executorService = executorService;
    }

    @Override
    protected void processTable(String tableNameWithType) {
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: {}", (Object)tableNameWithType);
        boolean isRealtimeTable = TableNameBuilder.isRealtimeTableResource((String)tableNameWithType);
        if (isRealtimeTable && new StreamConfig(tableNameWithType, IngestionConfigUtils.getStreamConfigMap((TableConfig)tableConfig)).hasHighLevelConsumerType()) {
            return;
        }
        boolean relocate = false;
        if (TierConfigUtils.shouldRelocateToTiers((TableConfig)tableConfig)) {
            relocate = true;
            LOGGER.info("Relocating segments to tiers for table: {}", (Object)tableNameWithType);
        }
        if (isRealtimeTable && InstanceAssignmentConfigUtils.shouldRelocateCompletedSegments((TableConfig)tableConfig)) {
            relocate = true;
            LOGGER.info("Relocating COMPLETED segments for table: {}", (Object)tableNameWithType);
        }
        if (!relocate) {
            LOGGER.debug("No need to relocate segments of table: {}", (Object)tableNameWithType);
            return;
        }
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)-1);
        this._executorService.submit(() -> this.lambda$processTable$0(tableConfig, (Configuration)rebalanceConfig, tableNameWithType));
    }

    private /* synthetic */ void lambda$processTable$0(TableConfig tableConfig, Configuration rebalanceConfig, String tableNameWithType) {
        try {
            RebalanceResult rebalance = new TableRebalancer(this._pinotHelixResourceManager.getHelixZkManager()).rebalance(tableConfig, rebalanceConfig);
            switch (rebalance.getStatus()) {
                case NO_OP: {
                    LOGGER.info("All segments are already relocated for table: {}", (Object)tableNameWithType);
                    break;
                }
                case DONE: {
                    LOGGER.info("Finished relocating segments for table: {}", (Object)tableNameWithType);
                    break;
                }
                default: {
                    LOGGER.error("Relocation failed for table: {}", (Object)tableNameWithType);
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }
}

