/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceReplicaGroupPartitionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceReplicaGroupPartitionSelector.class);
    private final InstanceReplicaGroupPartitionConfig _replicaGroupPartitionConfig;
    private final String _tableNameWithType;

    public InstanceReplicaGroupPartitionSelector(InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, String tableNameWithType) {
        this._replicaGroupPartitionConfig = replicaGroupPartitionConfig;
        this._tableNameWithType = tableNameWithType;
    }

    /*
     * WARNING - void declaration
     */
    public void selectInstances(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions) {
        int numPools = poolToInstanceConfigsMap.size();
        Preconditions.checkState((numPools != 0 ? 1 : 0) != 0, (Object)"No pool qualified for selection");
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        ArrayList<Integer> pools = new ArrayList<Integer>(poolToInstanceConfigsMap.keySet());
        pools.sort(null);
        LOGGER.info("Starting instance replica-group/partition selection for table: {} with hash: {} from pools: {}", new Object[]{this._tableNameWithType, tableNameHash, pools});
        if (this._replicaGroupPartitionConfig.isReplicaGroupBased()) {
            int n;
            int n2;
            int n3;
            int numReplicaGroups = this._replicaGroupPartitionConfig.getNumReplicaGroups();
            Preconditions.checkState((numReplicaGroups > 0 ? 1 : 0) != 0, (Object)"Number of replica-groups must be positive");
            TreeMap<Integer, List> poolToReplicaGroupIdsMap = new TreeMap<Integer, List>();
            for (int replicaId = 0; replicaId < numReplicaGroups; ++replicaId) {
                int pool2 = (Integer)pools.get((tableNameHash + replicaId) % numPools);
                poolToReplicaGroupIdsMap.computeIfAbsent(pool2, k -> new ArrayList()).add(replicaId);
            }
            LOGGER.info("Selecting {} replica-groups from pool: {} for table: {}", new Object[]{numReplicaGroups, poolToReplicaGroupIdsMap, this._tableNameWithType});
            int numInstancesPerReplicaGroup = this._replicaGroupPartitionConfig.getNumInstancesPerReplicaGroup();
            if (numInstancesPerReplicaGroup > 0) {
                for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                    int n4 = (Integer)entry.getKey();
                    int numInstancesInPool = poolToInstanceConfigsMap.get(n4).size();
                    int numInstancesToSelect = numInstancesPerReplicaGroup * ((List)entry.getValue()).size();
                    Preconditions.checkState((numInstancesToSelect <= numInstancesInPool ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)n4, (Object)numInstancesInPool, (Object)numInstancesToSelect);
                }
            } else {
                numInstancesPerReplicaGroup = Integer.MAX_VALUE;
                for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                    int numInstancesInPool;
                    int n5 = (Integer)entry.getKey();
                    int numReplicaGroupsInPool = ((List)entry.getValue()).size();
                    Preconditions.checkState((numReplicaGroupsInPool <= (numInstancesInPool = poolToInstanceConfigsMap.get(n5).size()) ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s, cannot select %s replica-groups from %s instances", (Object)n5, (Object)numReplicaGroupsInPool, (Object)numInstancesInPool);
                    numInstancesPerReplicaGroup = Math.min(numInstancesPerReplicaGroup, numInstancesInPool / numReplicaGroupsInPool);
                }
            }
            LOGGER.info("Selecting {} instances per replica-group for table: {}", (Object)numInstancesPerReplicaGroup, (Object)this._tableNameWithType);
            String[][] replicaGroupIdToInstancesMap = new String[numReplicaGroups][numInstancesPerReplicaGroup];
            for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                List<InstanceConfig> instanceConfigsInPool = poolToInstanceConfigsMap.get(entry.getKey());
                List replicaGroupIdsInPool = (List)entry.getValue();
                int instanceIdInPool = 0;
                for (int instanceIdInReplicaGroup = 0; instanceIdInReplicaGroup < numInstancesPerReplicaGroup; ++instanceIdInReplicaGroup) {
                    Iterator iterator = replicaGroupIdsInPool.iterator();
                    while (iterator.hasNext()) {
                        int replicaGroupId = (Integer)iterator.next();
                        replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup] = instanceConfigsInPool.get(instanceIdInPool++).getInstanceName();
                    }
                }
            }
            int n6 = this._replicaGroupPartitionConfig.getNumPartitions();
            if (n6 <= 0) {
                n3 = 1;
            }
            if ((n2 = this._replicaGroupPartitionConfig.getNumInstancesPerPartition()) > 0) {
                Preconditions.checkState((n2 <= numInstancesPerReplicaGroup ? 1 : 0) != 0, (String)"Number of instances per partition: %s must be smaller or equal to number of instances per replica-group: %s", (int)n2, (int)numInstancesPerReplicaGroup);
            } else {
                n = numInstancesPerReplicaGroup;
            }
            LOGGER.info("Selecting {} partitions, {} instances per partition within a replica-group for table: {}", new Object[]{n3, n, this._tableNameWithType});
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                int instanceIdInReplicaGroup = 0;
                for (int partitionId = 0; partitionId < n3; ++partitionId) {
                    ArrayList<String> instancesInPartition = new ArrayList<String>(n);
                    for (int instanceIdInPartition = 0; instanceIdInPartition < n; ++instanceIdInPartition) {
                        instancesInPartition.add(replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup]);
                        instanceIdInReplicaGroup = (instanceIdInReplicaGroup + 1) % numInstancesPerReplicaGroup;
                    }
                    instancesInPartition.sort(null);
                    LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}", new Object[]{instancesInPartition, replicaGroupId, partitionId, this._tableNameWithType});
                    instancePartitions.setInstances(partitionId, replicaGroupId, instancesInPartition);
                }
            }
        } else {
            void var11_29;
            int pool = (Integer)pools.get(tableNameHash % numPools);
            LOGGER.info("Selecting pool: {} for table: {}", (Object)pool, (Object)this._tableNameWithType);
            List<InstanceConfig> instanceConfigs = poolToInstanceConfigsMap.get(pool);
            int numInstanceConfigs = instanceConfigs.size();
            int numInstancesToSelect = this._replicaGroupPartitionConfig.getNumInstances();
            if (numInstancesToSelect > 0) {
                Preconditions.checkState((numInstancesToSelect <= numInstanceConfigs ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)pool, (Object)numInstanceConfigs, (Object)numInstancesToSelect);
            } else {
                numInstancesToSelect = numInstanceConfigs;
            }
            ArrayList<String> arrayList = new ArrayList<String>(numInstancesToSelect);
            boolean bl = false;
            while (var11_29 < numInstancesToSelect) {
                arrayList.add(instanceConfigs.get((int)var11_29).getInstanceName());
                ++var11_29;
            }
            arrayList.sort(null);
            LOGGER.info("Selecting instances: {} for table: {}", arrayList, (Object)this._tableNameWithType);
            instancePartitions.setInstances(0, 0, arrayList);
        }
    }
}

