/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class SelectionsRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        for (Expression expression : pinotQuery.getSelectList()) {
            SelectionsRewriter.tryToRewriteArrayFunction(expression);
        }
        return pinotQuery;
    }

    private static void tryToRewriteArrayFunction(Expression expression) {
        if (!expression.isSetFunctionCall()) {
            return;
        }
        Function functionCall = expression.getFunctionCall();
        switch (CalciteSqlParser.canonicalize(functionCall.getOperator())) {
            case "sum": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYSUM.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.SUMMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
            case "min": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYMIN.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.MINMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
            case "max": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYMAX.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.MAXMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
        }
        for (Expression operand : functionCall.getOperands()) {
            SelectionsRewriter.tryToRewriteArrayFunction(operand);
        }
    }
}

