/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlKind;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class PredicateComparisonRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Expression havingExpression;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            pinotQuery.setFilterExpression(PredicateComparisonRewriter.updateComparisonPredicate(filterExpression));
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            pinotQuery.setHavingExpression(PredicateComparisonRewriter.updateComparisonPredicate(havingExpression));
        }
        return pinotQuery;
    }

    private static Expression updateComparisonPredicate(Expression expression) {
        Function function = expression.getFunctionCall();
        if (function != null) {
            FilterKind filterKind;
            String operator = function.getOperator().toUpperCase();
            try {
                filterKind = FilterKind.valueOf(operator);
            }
            catch (Exception e) {
                throw new SqlCompilationException("Unsupported filter kind: " + operator);
            }
            List<Expression> operands = function.getOperands();
            switch (filterKind) {
                case AND: 
                case OR: {
                    operands.replaceAll(PredicateComparisonRewriter::updateComparisonPredicate);
                    break;
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    Expression firstOperand = operands.get(0);
                    Expression secondOperand = operands.get(1);
                    if (firstOperand.isSetLiteral()) {
                        if (secondOperand.isSetLiteral()) break;
                        function.setOperator(PredicateComparisonRewriter.getOppositeOperator(filterKind).name());
                        operands.set(0, secondOperand);
                        operands.set(1, firstOperand);
                        break;
                    }
                    if (secondOperand.isSetLiteral()) break;
                    Expression minusExpression = RequestUtils.getFunctionExpression(SqlKind.MINUS.name());
                    minusExpression.getFunctionCall().setOperands(Arrays.asList(firstOperand, secondOperand));
                    operands.set(0, minusExpression);
                    operands.set(1, RequestUtils.getLiteralExpression(0L));
                    break;
                }
                default: {
                    int numOperands = operands.size();
                    for (int i = 1; i < numOperands; ++i) {
                        if (operands.get(i).isSetLiteral()) continue;
                        throw new SqlCompilationException(String.format("For %s predicate, the operands except for the first one must be literal, got: %s", new Object[]{filterKind, expression}));
                    }
                }
            }
        }
        return expression;
    }

    private static FilterKind getOppositeOperator(FilterKind filterKind) {
        switch (filterKind) {
            case GREATER_THAN: {
                return FilterKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return FilterKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return FilterKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return FilterKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return filterKind;
    }
}

