/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import org.apache.pinot.common.function.FunctionDefinitionRegistry;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;

public class OutputColumnAstNode
extends BaseAstNode {
    @Override
    public void updateBrokerRequest(BrokerRequest brokerRequest) {
        for (AstNode astNode : this.getChildren()) {
            BaseAstNode node;
            if (astNode instanceof FunctionCallAstNode) {
                String functionName = ((FunctionCallAstNode)astNode).getName();
                if (FunctionDefinitionRegistry.isAggFunc(functionName)) {
                    node = (FunctionCallAstNode)astNode;
                    brokerRequest.addToAggregationsInfo(((FunctionCallAstNode)node).buildAggregationInfo());
                    continue;
                }
                Selection selection = brokerRequest.getSelections();
                if (selection == null) {
                    selection = new Selection();
                    brokerRequest.setSelections(selection);
                }
                TransformExpressionTree transformExpressionTree = TransformExpressionTree.compileToExpressionTree(((FunctionCallAstNode)astNode).getExpression());
                selection.addToSelectionColumns(transformExpressionTree.toString());
                continue;
            }
            if (astNode instanceof IdentifierAstNode) {
                Selection selection = brokerRequest.getSelections();
                if (selection == null) {
                    selection = new Selection();
                    brokerRequest.setSelections(selection);
                }
                node = (IdentifierAstNode)astNode;
                selection.addToSelectionColumns(((IdentifierAstNode)node).getName());
                continue;
            }
            throw new Pql2CompilationException("Output column is neither a function nor an identifier");
        }
    }

    @Override
    public void updatePinotQuery(PinotQuery pinotQuery) {
        for (AstNode astNode : this.getChildren()) {
            BaseAstNode node;
            if (astNode instanceof FunctionCallAstNode) {
                Expression functionExpr;
                node = (FunctionCallAstNode)astNode;
                if (((FunctionCallAstNode)node).getName().equalsIgnoreCase("count")) {
                    functionExpr = RequestUtils.getFunctionExpression(((FunctionCallAstNode)node).getName());
                    functionExpr.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression("*"));
                } else {
                    functionExpr = RequestUtils.getExpression(astNode);
                }
                pinotQuery.addToSelectList(functionExpr);
                continue;
            }
            if (astNode instanceof IdentifierAstNode) {
                node = (IdentifierAstNode)astNode;
                pinotQuery.addToSelectList(RequestUtils.createIdentifierExpression(((IdentifierAstNode)node).getName()));
                continue;
            }
            throw new Pql2CompilationException("Output column is neither a function nor an identifier");
        }
    }
}

