/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;

public class InPredicateAstNode
extends PredicateAstNode {
    private final boolean _isNotInClause;

    public InPredicateAstNode(boolean isNotInClause) {
        this._isNotInClause = isNotInClause;
    }

    public boolean isNotInClause() {
        return this._isNotInClause;
    }

    public ArrayList<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (AstNode astNode : this.getChildren()) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            LiteralAstNode node = (LiteralAstNode)astNode;
            values.add(node.getValueAsString());
        }
        return values;
    }

    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("IN predicate has more than one column/function");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else if (childNode instanceof FunctionCallAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("IN predicate has more than one column/function");
            }
            this._identifier = TransformExpressionTree.getStandardExpression(childNode);
        } else {
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("IN predicate has no identifier");
        }
        List<? extends AstNode> children = this.getChildren();
        int numChildren = children.size();
        ArrayList<String> values = new ArrayList<String>(numChildren);
        for (AstNode astNode : children) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            values.add(((LiteralAstNode)astNode).getValueAsString());
        }
        FilterOperator filterOperator = this._isNotInClause ? FilterOperator.NOT_IN : FilterOperator.IN;
        return new FilterQueryTree(this._identifier, values, filterOperator, null);
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("IN predicate has no identifier");
        }
        List<? extends AstNode> children = this.getChildren();
        int numChildren = children.size();
        ArrayList<Expression> operands = new ArrayList<Expression>(numChildren + 1);
        operands.add(RequestUtils.createIdentifierExpression(this._identifier));
        for (AstNode astNode : children) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            operands.add(RequestUtils.createLiteralExpression((LiteralAstNode)astNode));
        }
        FilterKind filterKind = this._isNotInClause ? FilterKind.NOT_IN : FilterKind.IN;
        Expression expression = RequestUtils.getFunctionExpression(filterKind.name());
        expression.getFunctionCall().setOperands(operands);
        return expression;
    }
}

