/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;

public class FunctionContext {
    private final Type _type;
    private String _functionName;
    private final List<ExpressionContext> _arguments;

    public FunctionContext(Type type, String functionName, List<ExpressionContext> arguments) {
        this._type = type;
        this._functionName = functionName.toLowerCase();
        this._arguments = arguments;
    }

    public Type getType() {
        return this._type;
    }

    public void setFunctionName(String functionName) {
        this._functionName = functionName.toLowerCase();
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public List<ExpressionContext> getArguments() {
        return this._arguments;
    }

    public void getColumns(Set<String> columns) {
        for (ExpressionContext argument : this._arguments) {
            argument.getColumns(columns);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionContext)) {
            return false;
        }
        FunctionContext that = (FunctionContext)o;
        return this._type == that._type && Objects.equals(this._functionName, that._functionName) && Objects.equals(this._arguments, that._arguments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._functionName, this._arguments});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._functionName).append('(');
        int numArguments = this._arguments.size();
        if (numArguments > 0) {
            stringBuilder.append(this._arguments.get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(',').append(this._arguments.get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }

    public static enum Type {
        AGGREGATION,
        TRANSFORM;

    }
}

