/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.minion.BaseTaskMetadata;

public class MergeRollupTaskMetadata
extends BaseTaskMetadata {
    private static final String WATERMARK_KEY_PREFIX = "watermarkMs_";
    private static final int WATERMARK_KEY_PREFIX_LENGTH = "watermarkMs_".length();
    private final String _tableNameWithType;
    private final Map<String, Long> _watermarkMap;

    public MergeRollupTaskMetadata(String tableNameWithType, Map<String, Long> watermarkMap) {
        this._tableNameWithType = tableNameWithType;
        this._watermarkMap = watermarkMap;
    }

    @Override
    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public Map<String, Long> getWatermarkMap() {
        return this._watermarkMap;
    }

    public static MergeRollupTaskMetadata fromZNRecord(ZNRecord znRecord) {
        HashMap<String, Long> watermarkMap = new HashMap<String, Long>();
        Map fields = znRecord.getSimpleFields();
        for (Map.Entry entry : fields.entrySet()) {
            if (!((String)entry.getKey()).startsWith(WATERMARK_KEY_PREFIX)) continue;
            watermarkMap.put(((String)entry.getKey()).substring(WATERMARK_KEY_PREFIX_LENGTH), Long.parseLong((String)entry.getValue()));
        }
        return new MergeRollupTaskMetadata(znRecord.getId(), watermarkMap);
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._tableNameWithType);
        for (Map.Entry<String, Long> entry : this._watermarkMap.entrySet()) {
            znRecord.setLongField(WATERMARK_KEY_PREFIX + entry.getKey(), entry.getValue().longValue());
        }
        return znRecord;
    }
}

