/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class StringFunctions {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    private StringFunctions() {
    }

    @ScalarFunction
    public static String reverse(String input) {
        return StringUtils.reverse((String)input);
    }

    @ScalarFunction
    public static String lower(String input) {
        return input.toLowerCase();
    }

    @ScalarFunction
    public static String upper(String input) {
        return input.toUpperCase();
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex) {
        return input.substring(beginIndex);
    }

    @ScalarFunction
    public static String substr(String input, int beginIndex, int endIndex) {
        if (endIndex == -1) {
            return StringFunctions.substr(input, beginIndex);
        }
        return input.substring(beginIndex, endIndex);
    }

    @ScalarFunction
    public static String concat(String input1, String input2, String seperator) {
        String result = input1;
        result = result + seperator + input2;
        return result;
    }

    @ScalarFunction
    public static String trim(String input) {
        return input.trim();
    }

    @ScalarFunction
    public static String trim(String end, String characters, String value) {
        int startIndex;
        int length = value.length();
        int endIndex = length;
        if (end.equals("BOTH") || end.equals("LEADING")) {
            for (startIndex = 0; startIndex < endIndex && characters.indexOf(value.charAt(startIndex)) >= 0; ++startIndex) {
            }
        }
        if (end.equals("BOTH") || end.equals("TRAILING")) {
            while (startIndex < endIndex && characters.indexOf(value.charAt(endIndex - 1)) >= 0) {
                --endIndex;
            }
        }
        if (startIndex > 0 || endIndex < length) {
            return value.substring(startIndex, endIndex);
        }
        return value;
    }

    @ScalarFunction
    public static String ltrim(String input) {
        return LTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static String rtrim(String input) {
        return RTRIM.matcher(input).replaceAll("");
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp) {
        return StringFunctions.regexpExtract(value, regexp, 0, "");
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp, int group) {
        return StringFunctions.regexpExtract(value, regexp, group, "");
    }

    @ScalarFunction
    public static String regexpExtract(String value, String regexp, int group, String defaultValue) {
        Pattern p = Pattern.compile(regexp);
        Matcher matcher = p.matcher(value);
        if (matcher.find() && matcher.groupCount() >= group) {
            return matcher.group(group);
        }
        return defaultValue;
    }

    @ScalarFunction
    public static int length(String input) {
        return input.length();
    }

    @ScalarFunction
    public static int strpos(String input, String find, int instance) {
        return StringUtils.ordinalIndexOf((CharSequence)input, (CharSequence)find, (int)instance);
    }

    @ScalarFunction
    public static int strpos(String input, String find) {
        return StringUtils.indexOf((CharSequence)input, (CharSequence)find);
    }

    @ScalarFunction
    public static int strrpos(String input, String find) {
        return StringUtils.lastIndexOf((CharSequence)input, (CharSequence)find);
    }

    @ScalarFunction
    public static int strrpos(String input, String find, int instance) {
        return StringUtils.lastIndexOf((CharSequence)input, (CharSequence)find, (int)instance);
    }

    @ScalarFunction
    public static boolean startsWith(String input, String prefix) {
        return input.startsWith(prefix);
    }

    @ScalarFunction
    public static String replace(String input, String find, String substitute) {
        return StringUtils.replace((String)input, (String)find, (String)substitute);
    }

    @ScalarFunction
    public static String rpad(String input, int size, String pad) {
        return StringUtils.rightPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static String lpad(String input, int size, String pad) {
        return StringUtils.leftPad((String)input, (int)size, (String)pad);
    }

    @ScalarFunction
    public static int codepoint(String input) {
        return input.codePointAt(0);
    }

    @ScalarFunction
    public static String chr(int codepoint) {
        char[] result = Character.toChars(codepoint);
        return new String(result);
    }

    @ScalarFunction
    public static byte[] toUtf8(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    @ScalarFunction
    public static String normalize(String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFC);
    }

    @ScalarFunction
    public static String normalize(String input, String form) {
        Normalizer.Form targetForm = Normalizer.Form.valueOf(form);
        return Normalizer.normalize(input, targetForm);
    }

    @ScalarFunction
    public static String[] split(String input, String delimiter) {
        return StringUtils.split((String)input, (String)delimiter);
    }

    @ScalarFunction
    public static String remove(String input, String search) {
        return StringUtils.remove((String)input, (String)search);
    }

    @ScalarFunction
    public static int hammingDistance(String input1, String input2) {
        if (input1.length() != input2.length()) {
            return -1;
        }
        int distance = 0;
        for (int i = 0; i < input1.length(); ++i) {
            if (input1.charAt(i) == input2.charAt(i)) continue;
            ++distance;
        }
        return distance;
    }

    @ScalarFunction
    public static boolean contains(String input, String substring) {
        return input.contains(substring);
    }

    @ScalarFunction
    public static int strcmp(String input1, String input2) {
        return input1.compareTo(input2);
    }
}

