/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class ArrayFunctions {
    private ArrayFunctions() {
    }

    @ScalarFunction
    public static int[] arrayReverseInt(int[] values) {
        int[] clone = (int[])values.clone();
        ArrayUtils.reverse((int[])clone);
        return clone;
    }

    @ScalarFunction
    public static String[] arrayReverseString(String[] values) {
        Object[] clone = (String[])values.clone();
        ArrayUtils.reverse((Object[])clone);
        return clone;
    }

    @ScalarFunction
    public static int[] arraySortInt(int[] values) {
        int[] clone = (int[])values.clone();
        Arrays.sort(clone);
        return clone;
    }

    @ScalarFunction
    public static String[] arraySortString(String[] values) {
        Object[] clone = (String[])values.clone();
        Arrays.sort(clone);
        return clone;
    }

    @ScalarFunction
    public static int arrayIndexOfInt(int[] values, int valueToFind) {
        return ArrayUtils.indexOf((int[])values, (int)valueToFind);
    }

    @ScalarFunction
    public static int arrayIndexOfString(String[] values, String valueToFind) {
        return ArrayUtils.indexOf((Object[])values, (Object)valueToFind);
    }

    @ScalarFunction
    public static boolean arrayContainsInt(int[] values, int valueToFind) {
        return ArrayUtils.contains((int[])values, (int)valueToFind);
    }

    @ScalarFunction
    public static boolean arrayContainsString(String[] values, String valueToFind) {
        return ArrayUtils.contains((Object[])values, (Object)valueToFind);
    }

    @ScalarFunction
    public static int[] arraySliceInt(int[] values, int start, int end) {
        return Arrays.copyOfRange(values, start, end);
    }

    @ScalarFunction
    public static String[] arraySliceString(String[] values, int start, int end) {
        return Arrays.copyOfRange(values, start, end);
    }

    @ScalarFunction
    public static int[] arrayDistinctInt(int[] values) {
        return new IntLinkedOpenHashSet(values).toIntArray();
    }

    @ScalarFunction
    public static String[] arrayDistinctString(String[] values) {
        return (String[])new ObjectLinkedOpenHashSet((Object[])values).toArray((Object[])new String[0]);
    }

    @ScalarFunction
    public static int[] arrayRemoveInt(int[] values, int element) {
        return ArrayUtils.removeElement((int[])values, (int)element);
    }

    @ScalarFunction
    public static String[] arrayRemoveString(String[] values, String element) {
        return (String[])ArrayUtils.removeElement((Object[])values, (Object)element);
    }

    @ScalarFunction
    public static int[] arrayUnionInt(int[] values1, int[] values2) {
        IntLinkedOpenHashSet set = new IntLinkedOpenHashSet(values1);
        set.addAll((IntCollection)IntArrayList.wrap((int[])values2));
        return set.toIntArray();
    }

    @ScalarFunction
    public static String[] arrayUnionString(String[] values1, String[] values2) {
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet((Object[])values1);
        set.addAll(Arrays.asList(values2));
        return (String[])set.toArray((Object[])new String[0]);
    }

    @ScalarFunction
    public static int[] arrayConcatInt(int[] values1, int[] values2) {
        return ArrayUtils.addAll((int[])values1, (int[])values2);
    }

    @ScalarFunction
    public static String[] arrayConcatString(String[] values1, String[] values2) {
        return (String[])ArrayUtils.addAll((Object[])values1, (Object[])values2);
    }
}

