/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.PinotDataType;

public class FunctionInvoker {
    private final Method _method;
    private final Class<?>[] _parameterClasses;
    private final PinotDataType[] _parameterTypes;
    private final Object _instance;

    public FunctionInvoker(FunctionInfo functionInfo) {
        this._method = functionInfo.getMethod();
        Class<?>[] parameterClasses = this._method.getParameterTypes();
        int numParameters = parameterClasses.length;
        this._parameterClasses = new Class[numParameters];
        this._parameterTypes = new PinotDataType[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterClass = parameterClasses[i];
            this._parameterClasses[i] = parameterClass;
            this._parameterTypes[i] = FunctionUtils.getParameterType(parameterClass);
        }
        if (Modifier.isStatic(this._method.getModifiers())) {
            this._instance = null;
        } else {
            Class<?> clazz = functionInfo.getClazz();
            try {
                Constructor<?> constructor = functionInfo.getClazz().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this._instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Caught exception while constructing class: " + clazz, e);
            }
        }
    }

    public Method getMethod() {
        return this._method;
    }

    public Class<?>[] getParameterClasses() {
        return this._parameterClasses;
    }

    public PinotDataType[] getParameterTypes() {
        return this._parameterTypes;
    }

    public void convertTypes(Object[] arguments) {
        int numParameters = this._parameterClasses.length;
        Preconditions.checkArgument((arguments.length == numParameters ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)this._method, (Object)numParameters, (Object)arguments.length);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> argumentClass;
            Class<?> parameterClass;
            Object argument = arguments[i];
            if (argument == null || (parameterClass = this._parameterClasses[i]).isAssignableFrom(argumentClass = argument.getClass())) continue;
            PinotDataType parameterType = this._parameterTypes[i];
            PinotDataType argumentType = FunctionUtils.getArgumentType(argumentClass);
            Preconditions.checkArgument((parameterType != null && argumentType != null ? 1 : 0) != 0, (String)"Cannot convert value from class: %s to class: %s", argumentClass, parameterClass);
            arguments[i] = parameterType.convert(argument, argumentType);
        }
    }

    public Class<?> getResultClass() {
        return this._method.getReturnType();
    }

    public Object invoke(Object[] arguments) {
        try {
            return this._method.invoke(this._instance, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException("Caught exception while invoking method: " + this._method + " with arguments: " + Arrays.toString(arguments), e);
        }
    }
}

