/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.unmarshalling.sse;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.settings.OversizedSseStrategy;
import org.apache.pekko.http.scaladsl.settings.OversizedSseStrategy$DeadLetter$;
import org.apache.pekko.http.scaladsl.settings.OversizedSseStrategy$FailStream$;
import org.apache.pekko.http.scaladsl.settings.OversizedSseStrategy$LogAndSkip$;
import org.apache.pekko.http.scaladsl.settings.OversizedSseStrategy$Truncate$;
import org.apache.pekko.http.scaladsl.unmarshalling.sse.LineParser$;
import org.apache.pekko.http.scaladsl.unmarshalling.sse.OversizedSseLine;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005mq!\u0002\t\u0012\u0011\u0013\u0001c!\u0002\u0012\u0012\u0011\u0013\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007c\u0005\u0001\u000b\u0011\u0002\u0018\t\u000fI\n!\u0019!C\u0001[!11'\u0001Q\u0001\n9Bq\u0001N\u0001\u0012\u0002\u0013\u0005QG\u0002\u0003##\u0019i\u0005\u0002C6\t\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011=D!\u0011!Q\u0001\n]BQA\u000b\u0005\u0005\u0002ADQA\u000b\u0005\u0005\u0002QDqA\u001e\u0005C\u0002\u0013\u0005s\u000f\u0003\u0004y\u0011\u0001\u0006IA\u0016\u0005\u0006s\"!\tE_\u0001\u000b\u0019&tW\rU1sg\u0016\u0014(B\u0001\n\u0014\u0003\r\u00198/\u001a\u0006\u0003)U\tQ\"\u001e8nCJ\u001c\b.\u00197mS:<'B\u0001\f\u0018\u0003!\u00198-\u00197bINd'B\u0001\r\u001a\u0003\u0011AG\u000f\u001e9\u000b\u0005iY\u0012!\u00029fW.|'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\"\u00035\t\u0011C\u0001\u0006MS:,\u0007+\u0019:tKJ\u001c\"!\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001%\u0001\u0002D%V\ta\u0006\u0005\u0002&_%\u0011\u0001G\n\u0002\u0005\u0005f$X-A\u0002D%\u0002\n!\u0001\u0014$\u0002\u000713\u0005%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002m)\u0012q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0003uU\t\u0001b]3ui&twm]\u0005\u0003ye\u0012Ac\u0014<feNL'0\u001a3Tg\u0016\u001cFO]1uK\u001eL8&\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015!C;oG\",7m[3e\u0015\t\u0019e%\u0001\u0006b]:|G/\u0019;j_:L!!\u0012!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u000b\u0002\u0002\u000fB\u0011\u0001JS\u0007\u0002\u0013*\u00111)G\u0005\u0003\u0017&\u00131\"\u00138uKJt\u0017\r\\!qS\"\u0012\u0001aR\n\u0003\u00119\u00032a\u0014+W\u001b\u0005\u0001&BA)S\u0003\u0015\u0019H/Y4f\u0015\t\u0019\u0016$\u0001\u0004tiJ,\u0017-\\\u0005\u0003+B\u0013!b\u0012:ba\"\u001cF/Y4f!\u00119\u0006L\u00171\u000e\u0003IK!!\u0017*\u0003\u0013\u0019cwn^*iCB,\u0007CA._\u001b\u0005a&BA/\u001a\u0003\u0011)H/\u001b7\n\u0005}c&A\u0003\"zi\u0016\u001cFO]5oOB\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"a\u0019\u0014\u000e\u0003\u0011T!!Z\u0010\u0002\rq\u0012xn\u001c;?\u0013\t9g%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA4'\u0003-i\u0017\r\u001f'j]\u0016\u001c\u0016N_3\u0011\u0005\u0015j\u0017B\u00018'\u0005\rIe\u000e^\u0001\u0012_Z,'o]5{K\u0012\u001cFO]1uK\u001eLHcA9sgB\u0011\u0011\u0005\u0003\u0005\u0006W.\u0001\r\u0001\u001c\u0005\b_.\u0001\n\u00111\u00018)\t\tX\u000fC\u0003l\u0019\u0001\u0007A.A\u0003tQ\u0006\u0004X-F\u0001W\u0003\u0019\u0019\b.\u00199fA\u0005Y1M]3bi\u0016dunZ5d)\rY\u0018q\u0002\n\u0007yz\f\u0019!!\u0003\u0007\tu|\u0001a\u001f\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003\u001f~L1!!\u0001Q\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007cA(\u0002\u0006%\u0019\u0011q\u0001)\u0003\u0013%s\u0007*\u00198eY\u0016\u0014\bcA(\u0002\f%\u0019\u0011Q\u0002)\u0003\u0015=+H\u000fS1oI2,'\u000fC\u0004\u0002\u0012=\u0001\r!a\u0005\u0002\u0015\u0005$HO]5ckR,7\u000fE\u0002X\u0003+I1!a\u0006S\u0005)\tE\u000f\u001e:jEV$Xm\u001d\u0015\u0003\u0011\u001d\u0003")
@InternalApi
public final class LineParser
extends GraphStage<FlowShape<ByteString, String>> {
    public final int org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize;
    public final OversizedSseStrategy org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$oversizedStrategy;
    private final FlowShape<ByteString, String> shape;

    public static OversizedSseStrategy $lessinit$greater$default$2() {
        return OversizedSseStrategy$FailStream$.MODULE$;
    }

    public static byte LF() {
        return LineParser$.MODULE$.LF();
    }

    public static byte CR() {
        return LineParser$.MODULE$.CR();
    }

    public FlowShape<ByteString, String> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes attributes) {
        return new InHandler(this){
            private LoggingAdapter log;
            private ByteString buffer;
            private boolean lastCharWasCr;
            private volatile boolean bitmap$0;
            private final /* synthetic */ LineParser $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$((InHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private ByteString buffer() {
                return this.buffer;
            }

            private void buffer_$eq(ByteString x$1) {
                this.buffer = x$1;
            }

            private boolean lastCharWasCr() {
                return this.lastCharWasCr;
            }

            private void lastCharWasCr_$eq(boolean x$1) {
                this.lastCharWasCr = x$1;
            }

            private LoggingAdapter log$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.log = Logging$.MODULE$.apply(this.materializer().system(), LineParser.class, LogSource$.MODULE$.fromAnyClass());
                        this.bitmap$0 = true;
                    }
                }
                return this.log;
            }

            private LoggingAdapter log() {
                if (!this.bitmap$0) {
                    return this.log$lzycompute();
                }
                return this.log;
            }

            public void onPush() {
                boolean _lastCharWasCr;
                ByteString remaining;
                int currentBufferStart = scala.math.package$.MODULE$.max(0, this.buffer().length() - 1);
                ByteString x$1 = this.buffer().$plus$plus((ByteString)this.grab(this.$outer.shape().in()));
                boolean x$3 = this.lastCharWasCr();
                int x$4 = 0;
                Vector x$5 = $anon$1.parseLines$default$4$1();
                Tuple3 tuple3 = this.parseLines$1(x$1, x$4, currentBufferStart, x$5, x$3);
                if (tuple3 != null) {
                    remaining = (ByteString)tuple3._1();
                    Vector parsedLines = (Vector)tuple3._2();
                    _lastCharWasCr = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (parsedLines.nonEmpty()) {
                        this.emitMultiple(this.$outer.shape().out(), (Iterable)parsedLines);
                    } else {
                        this.pull(this.$outer.shape().in());
                    }
                } else {
                    throw new MatchError(null);
                }
                this.lastCharWasCr_$eq(_lastCharWasCr);
                this.buffer_$eq(remaining);
            }

            public void onPull() {
                this.pull(this.$outer.shape().in());
            }

            private final Option handleLineOversized$1(int lineByteSize, String line) {
                OversizedSseStrategy oversizedSseStrategy = this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$oversizedStrategy;
                if (OversizedSseStrategy$FailStream$.MODULE$.equals(oversizedSseStrategy)) {
                    this.failStage(new IllegalStateException(new StringBuilder(122).append("SSE line size: ").append(lineByteSize).append(" exceeds max-line-size: ").append(this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize).append(". ").append("Configure pekko.http.sse.max-line-size or use oversized-message-handling setting.").toString()));
                    return None$.MODULE$;
                }
                if (OversizedSseStrategy$LogAndSkip$.MODULE$.equals(oversizedSseStrategy)) {
                    this.log().warning("Skipping oversized SSE message: {} bytes > {} max-line-size", (Object)BoxesRunTime.boxToInteger((int)lineByteSize), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize));
                    return None$.MODULE$;
                }
                if (OversizedSseStrategy$Truncate$.MODULE$.equals(oversizedSseStrategy)) {
                    this.log().info("Truncating oversized SSE message: {} bytes > {} max-line-size", (Object)BoxesRunTime.boxToInteger((int)lineByteSize), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize));
                    return new Some((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(line), this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize));
                }
                if (OversizedSseStrategy$DeadLetter$.MODULE$.equals(oversizedSseStrategy)) {
                    ActorRef qual$1 = this.materializer().system().deadLetters();
                    OversizedSseLine x$1 = new OversizedSseLine(line);
                    ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                    qual$1.$bang((Object)x$1, x$2);
                    return None$.MODULE$;
                }
                throw new MatchError((Object)oversizedSseStrategy);
            }

            private final Tuple3 parseLines$1(ByteString bs, int from, int at, Vector parsedLines, boolean lastCharWasCr) {
                while (at < bs.length()) {
                    boolean bl = false;
                    boolean bl2 = false;
                    byte by = bs.apply(at);
                    if (LineParser$.MODULE$.CR() == by) {
                        bl = true;
                        if (at < bs.length() - 1 && bs.apply(at + 1) == LineParser$.MODULE$.LF()) {
                            int lineByteSize = at - from;
                            String line = bs.slice(from, at).utf8String();
                            Vector newParsedLines = (Vector)(this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize > 0 && lineByteSize > this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize ? this.handleLineOversized$1(lineByteSize, line) : new Some((Object)line)).fold((Function0 & Serializable)() -> parsedLines, (Function1 & Serializable)x$1 -> (Vector)parsedLines.$colon$plus(x$1));
                            int n = at + 2;
                            lastCharWasCr = false;
                            parsedLines = newParsedLines;
                            at += 2;
                            from = n;
                            continue;
                        }
                    }
                    if (bl) {
                        int lineByteSize = at - from;
                        String line = bs.slice(from, at).utf8String();
                        Vector newParsedLines = (Vector)(this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize > 0 && lineByteSize > this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize ? this.handleLineOversized$1(lineByteSize, line) : new Some((Object)line)).fold((Function0 & Serializable)() -> parsedLines, (Function1 & Serializable)x$2 -> (Vector)parsedLines.$colon$plus(x$2));
                        int n = at + 1;
                        lastCharWasCr = true;
                        parsedLines = newParsedLines;
                        ++at;
                        from = n;
                        continue;
                    }
                    if (LineParser$.MODULE$.LF() == by) {
                        bl2 = true;
                        if (lastCharWasCr) {
                            int n = at + 1;
                            lastCharWasCr = false;
                            ++at;
                            from = n;
                            continue;
                        }
                    }
                    if (bl2) {
                        int lineByteSize = at - from;
                        String line = bs.slice(from, at).utf8String();
                        Vector newParsedLines = (Vector)(this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize > 0 && lineByteSize > this.$outer.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize ? this.handleLineOversized$1(lineByteSize, line) : new Some((Object)line)).fold((Function0 & Serializable)() -> parsedLines, (Function1 & Serializable)x$3 -> (Vector)parsedLines.$colon$plus(x$3));
                        int n = at + 1;
                        lastCharWasCr = false;
                        parsedLines = newParsedLines;
                        ++at;
                        from = n;
                        continue;
                    }
                    lastCharWasCr = false;
                    ++at;
                }
                return new Tuple3((Object)bs.drop(from), (Object)parsedLines, (Object)BoxesRunTime.boxToBoolean((boolean)lastCharWasCr));
            }

            private static final int parseLines$default$2$1() {
                return 0;
            }

            private static final Vector parseLines$default$4$1() {
                return package$.MODULE$.Vector().empty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.buffer = ByteString$.MODULE$.empty();
                this.lastCharWasCr = false;
                this.setHandlers($outer.shape().in(), $outer.shape().out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1(scala.collection.immutable.Vector ), $anonfun$onPush$2(scala.collection.immutable.Vector java.lang.String ), $anonfun$onPush$3(scala.collection.immutable.Vector ), $anonfun$onPush$4(scala.collection.immutable.Vector java.lang.String ), $anonfun$onPush$5(scala.collection.immutable.Vector ), $anonfun$onPush$6(scala.collection.immutable.Vector java.lang.String )}, serializedLambda);
            }
        };
    }

    public LineParser(int maxLineSize, OversizedSseStrategy oversizedStrategy) {
        this.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$maxLineSize = maxLineSize;
        this.org$apache$pekko$http$scaladsl$unmarshalling$sse$LineParser$$oversizedStrategy = oversizedStrategy;
        this.shape = new FlowShape(Inlet$.MODULE$.apply("LineParser.in"), Outlet$.MODULE$.apply("LineParser.out"));
    }

    public LineParser(int maxLineSize) {
        this(maxLineSize, OversizedSseStrategy$FailStream$.MODULE$);
    }
}

