/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.MacRomanEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.TrueTypeContainer;
import org.apache.pdfbox.preflight.font.descriptor.TrueTypeDescriptorHelper;

public class TrueTypeFontValidator
extends SimpleFontValidator<TrueTypeContainer> {
    public TrueTypeFontValidator(PreflightContext context, PDTrueTypeFont font) {
        super(context, (PDFontLike)font, font.getCOSObject(), new TrueTypeContainer(font));
    }

    @Override
    protected void createFontDescriptorHelper() {
        this.descriptorHelper = new TrueTypeDescriptorHelper(this.context, (PDTrueTypeFont)this.font, (TrueTypeContainer)this.fontContainer);
    }

    @Override
    protected void checkEncoding() {
        PDTrueTypeFont ttFont = (PDTrueTypeFont)this.font;
        PDFontDescriptor fd = ttFont.getFontDescriptor();
        if (fd != null) {
            Encoding encodingValue;
            if (fd.isNonSymbolic() && !((encodingValue = ttFont.getEncoding()) instanceof MacRomanEncoding) && !(encodingValue instanceof WinAnsiEncoding)) {
                ((TrueTypeContainer)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5", fd.getFontName() + ": The Encoding is invalid for the NonSymbolic TTF"));
            }
            if (fd.isSymbolic() && this.fontDictionary.getItem(COSName.ENCODING) != null) {
                ((TrueTypeContainer)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5", fd.getFontName() + ": The Encoding should be missing for the Symbolic TTF"));
            }
        }
    }
}

