/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.preflight.content.ContentStreamException;

public class StubOperator
extends OperatorProcessor {
    private final String name;

    public StubOperator(String name) {
        this.name = name;
    }

    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        String op = operator.getName();
        if ("S".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("B".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("f".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("F".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("f*".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("b".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("B*".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("b*".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("s".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("EMC".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("BMC".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("BDC".equals(op)) {
            this.checkTagAndPropertyOperands(arguments);
        } else if ("DP".equals(op)) {
            this.checkTagAndPropertyOperands(arguments);
        } else if ("c".equals(op)) {
            this.checkNumberOperands(arguments, 6);
        } else if ("v".equals(op)) {
            this.checkNumberOperands(arguments, 4);
        } else if ("y".equals(op)) {
            this.checkNumberOperands(arguments, 4);
        } else if ("d0".equals(op)) {
            this.checkNumberOperands(arguments, 2);
        } else if ("d1".equals(op)) {
            this.checkNumberOperands(arguments, 6);
        } else if ("g".equals(op)) {
            this.checkNumberOperands(arguments, 1);
        } else if ("G".equals(op)) {
            this.checkNumberOperands(arguments, 1);
        } else if ("gs".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("h".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("i".equals(op)) {
            this.checkNumberOperands(arguments, 1);
        } else if ("l".equals(op)) {
            this.checkNumberOperands(arguments, 2);
        } else if ("m".equals(op)) {
            this.checkNumberOperands(arguments, 2);
        } else if ("M".equals(op)) {
            this.checkNumberOperands(arguments, 1);
        } else if ("MP".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("n".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("re".equals(op)) {
            this.checkNumberOperands(arguments, 4);
        } else if ("ri".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("s".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("S".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("sh".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("'".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("Tj".equals(op)) {
            this.checkStringOperands(arguments, 1);
        } else if ("TJ".equals(op)) {
            this.checkArrayOperands(arguments, 1);
        } else if ("W".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("W*".equals(op)) {
            this.checkNoOperands(arguments);
        } else if ("\"".equals(op)) {
            this.checkNumberOperands(arguments.subList(0, 2), 2);
            this.checkStringOperands(arguments.subList(2, arguments.size()), 1);
        }
    }

    private void checkNoOperands(List<COSBase> arguments) throws ContentStreamException {
        if (arguments != null && !arguments.isEmpty()) {
            throw this.createInvalidArgumentsError();
        }
    }

    private void checkStringOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (int i = 0; i < length; ++i) {
            COSBase arg = arguments.get(i);
            if (!(arg instanceof COSName) && !(arg instanceof COSString)) {
                throw this.createInvalidArgumentsError();
            }
            if (arg instanceof COSName && ((COSName)arg).getName().length() > 127) {
                throw this.createLimitError("1.0.3", "A Name operand is too long");
            }
            if (!(arg instanceof COSString) || ((COSString)arg).getString().getBytes().length <= 65535) continue;
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
    }

    private void checkArrayOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (int i = 0; i < length; ++i) {
            COSBase arg = arguments.get(i);
            if (!(arg instanceof COSArray)) {
                throw this.createInvalidArgumentsError();
            }
            if (((COSArray)arg).size() <= 8191) continue;
            throw this.createLimitError("1.0.2", "Array has " + ((COSArray)arg).size() + " elements");
        }
    }

    private void checkNumberOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (int i = 0; i < length; ++i) {
            COSBase arg = arguments.get(i);
            if (!(arg instanceof COSFloat) && !(arg instanceof COSInteger)) {
                throw this.createInvalidArgumentsError();
            }
            if (arg instanceof COSInteger && (((COSInteger)arg).longValue() > Integer.MAX_VALUE || ((COSInteger)arg).longValue() < Integer.MIN_VALUE)) {
                throw this.createLimitError("1.0.6", "Invalid integer range in a Number operand");
            }
            if (!(arg instanceof COSFloat) || !(((COSFloat)arg).doubleValue() > 32767.0) && !(((COSFloat)arg).doubleValue() < -32767.0)) continue;
            throw this.createLimitError("1.0.6", "Invalid float range in a Number operand");
        }
    }

    private void checkTagAndPropertyOperands(List<COSBase> arguments) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != 2) {
            throw this.createInvalidArgumentsError();
        }
        COSBase arg = arguments.get(0);
        if (!(arg instanceof COSName) && !(arg instanceof COSString)) {
            throw this.createInvalidArgumentsError();
        }
        if (arg instanceof COSName && ((COSName)arg).getName().length() > 127) {
            throw this.createLimitError("1.0.3", "A Name operand is too long");
        }
        if (arg instanceof COSString && ((COSString)arg).getString().getBytes().length > 65535) {
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
        COSBase arg2 = arguments.get(1);
        if (!(arg2 instanceof COSName || arg2 instanceof COSString || arg2 instanceof COSDictionary)) {
            throw this.createInvalidArgumentsError();
        }
        if (arg2 instanceof COSName && ((COSName)arg2).getName().length() > 127) {
            throw this.createLimitError("1.0.3", "A Name operand is too long");
        }
        if (arg2 instanceof COSString && ((COSString)arg2).getString().getBytes().length > 65535) {
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
        if (arg2 instanceof COSDictionary && ((COSDictionary)arg2).size() > 4095) {
            throw this.createLimitError("1.0.1", "Dictionary has " + ((COSDictionary)arg2).size() + " entries");
        }
    }

    private ContentStreamException createInvalidArgumentsError() {
        ContentStreamException ex = new ContentStreamException("Invalid arguments");
        ex.setErrorCode("1.2.11");
        return ex;
    }

    private ContentStreamException createLimitError(String errorCode, String details) {
        ContentStreamException ex = new ContentStreamException(details);
        ex.setErrorCode(errorCode);
        return ex;
    }

    public String getName() {
        return this.name;
    }
}

