/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class ICCProfileWrapper {
    private final ICC_Profile profile;
    private final ICC_ColorSpace colorSpace;

    public ICCProfileWrapper(ICC_Profile _profile) {
        this.profile = _profile;
        this.colorSpace = new ICC_ColorSpace(_profile);
    }

    public int getColorSpaceType() {
        return this.colorSpace.getType();
    }

    public ICC_Profile getProfile() {
        return this.profile;
    }

    public boolean isRGBColorSpace() {
        return 5 == this.colorSpace.getType();
    }

    public boolean isCMYKColorSpace() {
        return 9 == this.colorSpace.getType();
    }

    public boolean isGrayColorSpace() {
        return 6 == this.colorSpace.getType();
    }

    private static ICCProfileWrapper searchFirstICCProfile(PreflightContext context) throws ValidationException {
        PreflightDocument document = context.getDocument();
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        COSBase cBase = catalog.getCOSDictionary().getItem(COSName.getPDFName((String)"OutputIntents"));
        COSArray outputIntents = COSUtils.getAsArray(cBase, document.getDocument());
        for (int i = 0; outputIntents != null && i < outputIntents.size(); ++i) {
            COSDictionary outputIntentDict = COSUtils.getAsDictionary(outputIntents.get(i), document.getDocument());
            COSBase destOutputProfile = outputIntentDict.getItem("DestOutputProfile");
            if (destOutputProfile == null) continue;
            try {
                PDStream stream = PDStream.createFromCOS((COSBase)COSUtils.getAsStream(destOutputProfile, document.getDocument()));
                if (stream == null) continue;
                ICC_Profile iccp = ICC_Profile.getInstance(stream.getByteArray());
                return new ICCProfileWrapper(iccp);
            }
            catch (IllegalArgumentException e) {
                context.addValidationError(new ValidationResult.ValidationError("2.1.4", "DestOutputProfile isn't a valid ICCProfile. Caused by : " + e.getMessage()));
                continue;
            }
            catch (IOException e) {
                context.addValidationError(new ValidationResult.ValidationError("2.1.4", "Unable to parse the ICCProfile. Caused by : " + e.getMessage()));
            }
        }
        return null;
    }

    public static ICCProfileWrapper getOrSearchICCProfile(PreflightContext context) throws ValidationException {
        ICCProfileWrapper profileWrapper = context.getIccProfileWrapper();
        if (profileWrapper == null && !context.isIccProfileAlreadySearched()) {
            profileWrapper = ICCProfileWrapper.searchFirstICCProfile(context);
            context.setIccProfileAlreadySearched(true);
        }
        return profileWrapper;
    }
}

